/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.common.model.Constant;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.IProperties;
import org.eclipse.buckminster.core.common.model.ValueHolder;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMContext
extends ExpandingProperties<Object> {
    private int m_tagInfoSquenceNumber = 0;
    private final Map<QualifiedDependency, NodeQuery> m_nodeQueries = new HashMap<QualifiedDependency, NodeQuery>();
    private final Map<String, String[]> m_filterAttributeUsageMap = new HashMap<String, String[]>();
    private final Map<String, TagInfo> m_knownTagInfos = new HashMap<String, TagInfo>();
    private static final Map<String, String> s_staticAdditions;
    private boolean m_continueOnError;
    private final Map<ComponentRequest, TagInfo> m_tagInfos = new HashMap<ComponentRequest, TagInfo>();
    private final Map<UUID, Object> m_userCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> m_bindingProperties = Collections.synchronizedMap(new HashMap());
    private MultiStatus m_status;
    private boolean m_silentStatus;

    static {
        HashMap<String, String> additions = new HashMap<String, String>();
        File homeFile = TargetPlatform.getPlatformInstallLocation();
        if (homeFile != null) {
            CorePlugin.getLogger().debug("Platform install location: %s", new Object[]{homeFile});
            additions.put("eclipse.home", homeFile.toString());
        } else {
            CorePlugin.getLogger().debug("Platform install location is NULL!", new Object[0]);
        }
        additions.put("workspace.root", ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString());
        try {
            additions.put("localhost", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        s_staticAdditions = additions;
    }

    public static String formatStatus(IStatus status) {
        StringWriter bld = new StringWriter();
        BufferedWriter wrt = new BufferedWriter(bld);
        try {
            RMContext.formatStatus(wrt, 0, status);
            wrt.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bld.toString();
    }

    private static IStatus addTagId(String tagId, IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            int idx = children.length;
            IStatus[] taggedChildren = new IStatus[idx];
            while (--idx >= 0) {
                taggedChildren[idx] = RMContext.addTagId(tagId, children[idx]);
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), taggedChildren, RMContext.addTagId(tagId, status.getMessage()), status.getException());
        }
        return new Status(status.getSeverity(), status.getPlugin(), RMContext.addTagId(tagId, status.getMessage()), status.getException());
    }

    private static String addTagId(String tagId, String msg) {
        String prefix = String.valueOf('[') + tagId + "] : ";
        if (msg == null) {
            msg = prefix;
        } else if (!msg.startsWith(prefix)) {
            msg = String.valueOf(prefix) + msg;
        }
        return msg;
    }

    private static void formatStatus(BufferedWriter wrt, int indent, IStatus status) throws IOException {
        int idx = 0;
        while (idx < indent) {
            wrt.append(' ');
            ++idx;
        }
        switch (status.getSeverity()) {
            case 1: {
                wrt.append("INFO    ");
                break;
            }
            case 2: {
                wrt.append("WARNING ");
                break;
            }
            case 4: {
                wrt.append("ERROR   ");
            }
        }
        wrt.append(status.getMessage());
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            wrt.newLine();
            RMContext.formatStatus(wrt, indent + 2, child);
            ++n2;
        }
        Throwable t = status.getException();
        if (t instanceof CoreException) {
            wrt.newLine();
            RMContext.formatStatus(wrt, indent + 2, ((CoreException)t).getStatus());
        }
    }

    public static Map<String, ? extends Object> getGlobalPropertyAdditions() {
        IProperties<String> sysProps = BMProperties.getSystemProperties();
        IStringVariableManager varMgr = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable[] vars = varMgr.getValueVariables();
        HashMap<String, Object> additions = new HashMap<String, Object>(s_staticAdditions.size() + sysProps.size() + vars.length + 6);
        additions.putAll(s_staticAdditions);
        try {
            ITargetPlatform tf = TargetPlatform.getInstance();
            additions.put("target.os", tf.getOS());
            additions.put("target.ws", tf.getWS());
            additions.put("target.arch", tf.getArch());
            additions.put("target.nl", tf.getNL());
            File location = tf.getLocation();
            if (location != null) {
                additions.put("target.location", location.getAbsolutePath());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        additions.put("generator.buildTimestamp.format", DateAndTimeUtils.toISOFormat(new Date()));
        IValueVariable[] iValueVariableArray = varMgr.getValueVariables();
        int n = iValueVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IValueVariable var = iValueVariableArray[n2];
            Object value = var.getValue();
            if ("*".equals(value)) {
                value = FilterUtils.MATCH_ALL_OBJ;
            }
            additions.put(var.getName(), value);
            ++n2;
        }
        for (Map.Entry sysProp : sysProps.entrySet()) {
            Object value = sysProp.getValue();
            if ("*".equals(value)) {
                value = FilterUtils.MATCH_ALL_OBJ;
            }
            additions.put((String)sysProp.getKey(), value);
        }
        return additions;
    }

    public RMContext(Map<String, ? extends Object> properties) {
        this(properties, null);
    }

    public RMContext(Map<String, ? extends Object> properties, RMContext source) {
        super(RMContext.getGlobalPropertyAdditions());
        this.putAll(properties, true);
        if (source != null) {
            this.m_userCache.putAll(source.getUserCache());
            this.m_tagInfos.putAll(source.getTagInfos());
            this.m_bindingProperties.putAll(source.getBindingProperties());
            this.m_filterAttributeUsageMap.putAll(source.getFilterAttributeUsageMap());
        }
    }

    public synchronized void addRequestStatus(IComponentRequest request, IStatus status) {
        Logger logger = CorePlugin.getLogger();
        if (logger.isInfoEnabled()) {
            status = RMContext.addTagId(this.getTagId(request), status);
        }
        if (!this.isSilentStatus()) {
            switch (status.getSeverity()) {
                case 4: {
                    logger.error(RMContext.formatStatus(status), new Object[0]);
                    break;
                }
                case 2: {
                    logger.warning(RMContext.formatStatus(status), new Object[0]);
                    break;
                }
                case 1: {
                    logger.info(RMContext.formatStatus(status), new Object[0]);
                }
            }
        }
        if (this.m_status == null) {
            this.m_status = new MultiStatus(CorePlugin.getID(), 0, new IStatus[]{status}, "Errors and Warnings", null);
        } else {
            this.m_status.merge(status);
        }
    }

    public synchronized void addTagInfo(ComponentRequest request, String info) {
        TagInfo tagInfo = this.m_tagInfos.get(request);
        if (tagInfo == null) {
            tagInfo = this.m_knownTagInfos.get(info);
            if (tagInfo == null) {
                tagInfo = new TagInfo(info);
                this.m_knownTagInfos.put(info, tagInfo);
            }
            this.m_tagInfos.put(request, tagInfo);
        }
    }

    public synchronized void clearStatus() {
        this.m_status = null;
    }

    public boolean emitWarningAndErrorTags() {
        IStatus status = this.getStatus();
        switch (status.getSeverity()) {
            case 4: {
                this.emitTagInfos();
                return true;
            }
            case 1: 
            case 2: {
                this.emitTagInfos();
            }
        }
        return false;
    }

    public String getBindingName(Resolution resolution, Map<String, ? extends Object> props) throws CoreException {
        ComponentRequest request = resolution.getRequest();
        String name = null;
        Attribute bindEntryPoint = resolution.getCSpec().getBindEntryPoint();
        if (bindEntryPoint instanceof IAction) {
            if (props == null) {
                props = this.getProperties(request);
            }
            name = ((Action)bindEntryPoint).getBindingName(props);
        }
        if (name == null) {
            name = request.getName();
        }
        return name;
    }

    public Map<String, String> getBindingProperties() {
        return this.m_bindingProperties;
    }

    public ComponentQuery getComponentQuery() {
        return null;
    }

    public Map<String, String[]> getFilterAttributeUsageMap() {
        return this.m_filterAttributeUsageMap;
    }

    public NodeQuery getNodeQuery(ComponentRequest request) {
        return this.getNodeQuery(new QualifiedDependency(request, this.getComponentQuery().getAttributes(request, this)));
    }

    public synchronized NodeQuery getNodeQuery(QualifiedDependency qualifiedDependency) {
        NodeQuery query = this.m_nodeQueries.get(qualifiedDependency);
        if (query == null) {
            query = new NodeQuery(this, qualifiedDependency);
            this.m_nodeQueries.put(qualifiedDependency, query);
        }
        return query;
    }

    public Map<String, ? extends Object> getProperties(ComponentName cName) {
        return new UnmodifiableMapUnion<String, Object>(cName.getProperties(), this);
    }

    public NodeQuery getRootNodeQuery() {
        return this.getNodeQuery(this.getComponentQuery().getExpandedRootRequest(this));
    }

    public IStatus getStatus() {
        MultiStatus status = this.m_status;
        if (status == null) {
            return Status.OK_STATUS;
        }
        return status;
    }

    public synchronized Map<ComponentRequest, TagInfo> getTagInfos() {
        this.initializeAllTagInfos();
        return this.m_tagInfos;
    }

    public Map<UUID, Object> getUserCache() {
        return this.m_userCache;
    }

    public boolean isContinueOnError() {
        return this.m_continueOnError;
    }

    public boolean isSilentStatus() {
        return this.m_silentStatus;
    }

    public void setContinueOnError(boolean flag) {
        this.m_continueOnError = flag;
    }

    @Override
    public ValueHolder<Object> setProperty(String key, ValueHolder<Object> propertyHolder) {
        Constant c;
        if (propertyHolder instanceof Constant && "*".equals((c = (Constant)propertyHolder).getConstantValue())) {
            propertyHolder = new Constant<FilterUtils.MatchAll>(FilterUtils.MATCH_ALL_OBJ);
            propertyHolder.setMutable(c.isMutable());
        }
        return super.setProperty(key, propertyHolder);
    }

    public void setSilentStatus(boolean flag) {
        this.m_silentStatus = flag;
    }

    protected synchronized boolean hasTagInfo(IComponentRequest request) {
        return this.m_tagInfos.containsKey(request);
    }

    protected void initializeAllTagInfos() {
    }

    protected void initializeTagInfo(IComponentRequest request) {
    }

    private void emitTagInfos() {
        Logger logger = CorePlugin.getLogger();
        if (!logger.isInfoEnabled()) {
            return;
        }
        TreeMap<String, TagInfo> sorted = new TreeMap<String, TagInfo>();
        for (TagInfo tagInfo : this.m_tagInfos.values()) {
            if (!tagInfo.isUsed()) continue;
            sorted.put(tagInfo.getTagId(), tagInfo);
        }
        if (sorted.size() == 0) {
            return;
        }
        this.m_tagInfos.clear();
        StringWriter bld = new StringWriter();
        BufferedWriter wrt = new BufferedWriter(bld);
        try {
            for (TagInfo tagInfo : sorted.values()) {
                wrt.write(tagInfo.toString());
                wrt.newLine();
            }
            wrt.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.info(bld.toString(), new Object[0]);
    }

    private synchronized String getTagId(IComponentRequest request) {
        TagInfo tagInfo = this.m_tagInfos.get(request);
        if (tagInfo == null) {
            this.initializeTagInfo(request);
        }
        if ((tagInfo = this.m_tagInfos.get(request)) != null) {
            tagInfo.setUsed();
            return tagInfo.getTagId();
        }
        return "0000";
    }

    public class TagInfo {
        private final int m_tagId;
        private final String m_infoString;
        private boolean m_used = false;

        private TagInfo(String infoString) {
            RMContext rMContext2 = RMContext.this;
            int n = rMContext2.m_tagInfoSquenceNumber + 1;
            rMContext2.m_tagInfoSquenceNumber = n;
            this.m_tagId = n;
            this.m_infoString = infoString;
        }

        public String getTagId() {
            StringBuilder bld = new StringBuilder();
            this.addTagId(bld);
            return bld.toString();
        }

        public boolean isUsed() {
            return this.m_used;
        }

        public void setUsed() {
            this.m_used = true;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("TAG-ID ");
            this.addTagId(bld);
            bld.append(" = ");
            bld.append(this.m_infoString);
            return bld.toString();
        }

        private void addTagId(StringBuilder bld) {
            String tagIdStr = Integer.toString(this.m_tagId);
            int len = tagIdStr.length();
            bld.append("0000");
            bld.setLength(bld.length() - len);
            bld.append(tagIdStr);
        }
    }
}

