/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.actor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.IActor;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActor
implements IActor,
IExecutableExtension {
    private static InheritableThreadLocal<Stack<IActionContext>> s_actionContext = new InheritableThreadLocal();
    private String m_name;
    private String m_id;
    private final Logger m_logger = CorePlugin.getLogger();
    private Action m_action;

    public static IActionContext getActiveContext() {
        Stack ctxStack = (Stack)s_actionContext.get();
        if (ctxStack == null || ctxStack.isEmpty()) {
            throw new IllegalStateException(Messages.No_active_IActionContext);
        }
        return (IActionContext)ctxStack.peek();
    }

    public static boolean getBooleanProperty(Map<String, String> properties, String key, boolean dflt) {
        String propVal = properties.get(key);
        if (propVal == null) {
            return dflt;
        }
        if ("true".equalsIgnoreCase(propVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(propVal)) {
            return false;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages._0_not_valid_value_of_boolean_property, (Object)propVal));
    }

    public static List<IPath> getPathList(IActionContext ctx, Attribute attr, boolean atBase) throws CoreException {
        PathGroup[] groups = attr.getPathGroups(ctx, null);
        if (groups.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IPath> pathList = new ArrayList<IPath>();
        PathGroup[] pathGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pathGroup = pathGroupArray[n2];
            IPath base = pathGroup.getBase();
            if (atBase) {
                pathList.add(base);
            } else {
                IPath[] iPathArray = pathGroup.getPaths();
                int n3 = iPathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath path = iPathArray[n4];
                    pathList.add(base.append(path));
                    ++n4;
                }
            }
            ++n2;
        }
        return pathList;
    }

    public static IPath getSingleAttributePath(IActionContext ctx, Attribute attr, boolean atBase) throws CoreException {
        IPath productPath = null;
        PathGroup[] pathGroupArray = attr.getPathGroups(ctx, null);
        int n = pathGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pathGroup = pathGroupArray[n2];
            IPath pp = null;
            if (atBase) {
                pp = pathGroup.getBase();
            } else {
                IPath[] paths = pathGroup.getPaths();
                if (paths.length == 1) {
                    pp = pathGroup.getBase().append(paths[0]);
                } else if (paths.length == 0) {
                    pp = pathGroup.getBase();
                }
            }
            if (pp == null) {
                productPath = null;
                break;
            }
            if (productPath == null) {
                productPath = pp;
            } else if (!productPath.equals((Object)pp)) {
                productPath = null;
                break;
            }
            ++n2;
        }
        if (productPath == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.product_for_action_0_must_be_single_path, (Object)attr.getQualifiedName()), (Object[])new Object[0]);
        }
        return productPath;
    }

    @Override
    public final String getId() {
        return this.m_id;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final void init(Action action) throws CoreException {
        this.m_action = action;
        if (this.m_logger.isDebugEnabled()) {
            StringBuilder bld = new StringBuilder();
            bld.append("init actor: ");
            bld.append(this.getId());
            bld.append('[');
            action.toString(bld);
            bld.append(']');
            this.loggableProps(bld, action.getActorProperties());
            this.m_logger.debug(bld.toString(), new Object[0]);
        }
        this.internalInit();
    }

    @Override
    public boolean isUpToDate(Action action, IModelCache ctx) throws CoreException {
        return false;
    }

    @Override
    public final synchronized IStatus perform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        Map<String, ? extends Object> props = ctx.getProperties();
        Stack<IActionContext> ctxStack = (Stack<IActionContext>)s_actionContext.get();
        if (ctxStack == null) {
            ctxStack = new Stack<IActionContext>();
            s_actionContext.set(ctxStack);
        }
        ctxStack.push(ctx);
        try {
            Action action = ctx.getAction();
            boolean quiet = ctx.isQuiet();
            boolean isDebug = this.m_logger.isDebugEnabled();
            if (isDebug || !quiet) {
                StringBuilder bld = new StringBuilder();
                bld.append("[start ");
                action.toString(bld);
                bld.append(']');
                if (isDebug) {
                    this.loggableActionInfo(bld);
                    this.loggableProps(bld, props);
                }
                this.m_logger.info(bld.toString(), new Object[0]);
            }
            ctx.getGlobalContext().scheduleRemoval((IPath)new Path(props.get("buckminster.temp").toString()));
            IStatus status = this.internalPerform(ctx, monitor);
            if (isDebug || !quiet) {
                StringBuilder bld = new StringBuilder();
                bld.append("[end ");
                action.toString(bld);
                bld.append(']');
                this.m_logger.info(bld.toString(), new Object[0]);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (Throwable t) {
            throw BuckminsterException.wrap((Throwable)t);
        }
        finally {
            ctxStack.pop();
            if (ctxStack.isEmpty()) {
                s_actionContext.set(null);
            }
        }
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.m_name = config.getAttribute("name");
        this.m_id = config.getAttribute("ID");
    }

    protected final String getActorProperty(String key) {
        return this.m_action.getActorProperties().get(key);
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected void internalInit() throws CoreException {
    }

    protected abstract IStatus internalPerform(IActionContext var1, IProgressMonitor var2) throws CoreException;

    private void loggableActionInfo(StringBuilder sb) {
        if (this.m_action.getPrerequisitesAlias() != null) {
            sb.append("\n  ");
            sb.append(Messages.Prerequisite_alias);
            sb.append(this.m_action.getPrerequisitesAlias());
        }
        if (this.m_action.getPrerequisiteRebase() != null) {
            sb.append("\n  ");
            sb.append(Messages.Prerequisite_rebase);
            sb.append(this.m_action.getPrerequisiteRebase().toOSString());
        }
        if (this.m_action.getProductAlias() != null) {
            sb.append("\n  ");
            sb.append(Messages.Product_alias);
            sb.append(this.m_action.getProductAlias());
        }
        if (this.m_action.getProductBase() != null) {
            sb.append("\n  ");
            sb.append(Messages.Product_base);
            sb.append(this.m_action.getProductBase().toOSString());
        }
    }

    private void loggableProps(StringBuilder sb, Map<String, ? extends Object> props) {
        Properties sysProps = System.getProperties();
        for (Map.Entry<String, ? extends Object> entry : props.entrySet()) {
            if (sysProps.getProperty(entry.getKey()) != null) continue;
            sb.append("\n  ");
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
    }
}

