/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.AbstractPreferencesCommand;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ExportPreferences
extends AbstractPreferencesCommand {
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        FilterOutputStream output = null;
        File prefsFile = this.getFile();
        try {
            output = prefsFile == null ? System.out : new BufferedOutputStream(new FileOutputStream(prefsFile));
            Platform.getPreferencesService().exportPreferences(this.getNode(), this.getFilter(), (OutputStream)output);
            return 0;
        }
        catch (IOException e) {
            throw new SimpleErrorExitException(NLS.bind((String)Messages.Unable_to_open_file_0, (Object)prefsFile));
        }
        finally {
            if (prefsFile != null) {
                IOUtils.close((Closeable)output);
            }
        }
    }
}

