/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launch
extends WorkspaceCommand {
    private static final OptionDescriptor LAUNCH_DESCRIPTOR = new OptionDescriptor('l', "launch", 3);
    private static final OptionDescriptor STDOUT_DESCRIPTOR = new OptionDescriptor(null, "stdout", 2);
    private static final OptionDescriptor STDERR_DESCRIPTOR = new OptionDescriptor(null, "stderr", 2);
    private String m_launchName;
    private String m_stdOutFile;
    private String m_stdErrFile;
    private IStreamMonitor[] m_stdOut;
    private IStreamMonitor[] m_stdErr;
    private List<StreamListener> m_listeners = new ArrayList<StreamListener>();
    private ILaunch m_launch;

    public ILaunch getLaunch() {
        return this.m_launch;
    }

    public String getStdErr() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.m_stdErr;
        int n = this.m_stdErr.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor err = iStreamMonitorArray[n2];
            content.append(err.getContents());
            ++n2;
        }
        return content.toString();
    }

    public String getStdOut() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.m_stdOut;
        int n = this.m_stdOut.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor out = iStreamMonitorArray[n2];
            content.append(out.getContents());
            ++n2;
        }
        return content.toString();
    }

    protected String getLaunchMode() {
        return "run";
    }

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(LAUNCH_DESCRIPTOR);
        appendHere.add(STDOUT_DESCRIPTOR);
        appendHere.add(STDERR_DESCRIPTOR);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        super.handleOption(option);
        if (option.is(LAUNCH_DESCRIPTOR)) {
            this.m_launchName = option.getValue();
        } else if (option.is(STDOUT_DESCRIPTOR)) {
            this.m_stdOutFile = option.getValue() == null ? "-" : option.getValue();
        } else if (option.is(STDERR_DESCRIPTOR)) {
            this.m_stdErrFile = option.getValue() == null ? "-" : option.getValue();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        if (this.m_launchName == null) {
            throw new UsageException(Messages.Launch_No_launch_config);
        }
        launchFile = ResourcesPlugin.getWorkspace().getRoot().findMember(this.m_launchName);
        if (launchFile == null) throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.m_launchName), (Object[])new Object[0]);
        if (launchFile.getType() != 1) throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.m_launchName), (Object[])new Object[0]);
        if (!launchFile.exists()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.m_launchName), (Object[])new Object[0]);
        }
        launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration((IFile)launchFile);
        this.m_launch = launchConfiguration.launch(this.getLaunchMode(), monitor);
        processes = this.m_launch.getProcesses();
        this.m_stdOut = new IStreamMonitor[processes.length];
        this.m_stdErr = new IStreamMonitor[processes.length];
        i = 0;
        while (i < processes.length) {
            this.m_stdOut[i] = processes[i].getStreamsProxy().getOutputStreamMonitor();
            if (this.m_stdOutFile != null) {
                new StreamListener(this.m_stdOut[i], this.m_stdOutFile, true);
            }
            this.m_stdErr[i] = processes[i].getStreamsProxy().getErrorStreamMonitor();
            if (this.m_stdErrFile != null) {
                new StreamListener(this.m_stdErr[i], this.m_stdErrFile, false);
            }
            ++i;
        }
        try {
            while (!this.m_launch.isTerminated()) {
                Thread.sleep(500L);
            }
            result = 0;
            var9_6 = processes;
            var8_7 = processes.length;
            var7_8 = 0;
            while (var7_8 < var8_7) {
                p = var9_6[var7_8];
                if (p.getExitValue() != 0) {
                    CorePlugin.getLogger().warning(Messages.Launch_Terminated_with_exit_status, new Object[]{p.getLabel(), p.getExitValue()});
                    result = p.getExitValue();
                }
                ++var7_8;
            }
            var11_10 = result;
            return var11_10;
        }
        finally {
            ** for (listener : this.m_listeners)
        }
lbl-1000:
        // 1 sources

        {
            listener.close();
            continue;
        }
lbl44:
        // 1 sources

        return var11_10;
    }

    private final class StreamListener
    implements IStreamListener {
        private PrintStream stream;

        public StreamListener(IStreamMonitor monitor, String outputFile, boolean stdout) {
            Launch.this.m_listeners.add(this);
            if ("-".equals(outputFile)) {
                this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
            } else {
                try {
                    this.stream = new PrintStream(outputFile);
                }
                catch (FileNotFoundException e) {
                    CorePlugin.getLogger().error((Throwable)e, Messages.Launch_Cannot_open_stream, new Object[]{outputFile});
                    this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
                }
            }
            this.stream.print(monitor.getContents());
            monitor.addListener((IStreamListener)this);
        }

        public void close() {
            if (this.stream != Logger.getOutStream() && this.stream != Logger.getErrStream()) {
                this.stream.close();
            }
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.stream.print(text);
        }
    }
}

