/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsetPreference
extends WorkspaceCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private boolean m_test = false;
    private String[] m_assignments;

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        if (option.is(TEST_DESCRIPTOR)) {
            this.m_test = true;
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length < 1) {
            throw new UsageException(Messages.You_must_provide_at_least_one_preference_to_unset);
        }
        this.m_assignments = unparsed;
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        PreferenceMappingManager prefManager = PreferenceMappingManager.getInstance(this.m_test);
        int idx = 0;
        while (idx < this.m_assignments.length) {
            String assignment = this.m_assignments[idx];
            BasicPreferenceHandler bph = prefManager.getHandler(assignment);
            bph.unset();
            System.out.println(NLS.bind((String)Messages.Unset_the_value_for_0, (Object)bph.getName()));
            ++idx;
        }
        return 0;
    }
}

