/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.Closeable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.JobBlocker;
import org.eclipse.buckminster.core.materializer.WorkspaceBindingInstallJob;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceCommand
extends AbstractCommand {
    private static final Pattern DEFINE_PATTERN = Pattern.compile("^([^=]+)(?:=(.+))?$");
    private static final OptionDescriptor DEFINE_DESCRIPTOR = new OptionDescriptor('D', "define", 3);
    private static final OptionDescriptor PROPERTIES_DESCRIPTOR = new OptionDescriptor('P', "properties", 3);
    private Map<String, String> m_props;
    private boolean m_inWorkspace = false;

    private static void saveWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(null, 300);
        try {
            IStatus saveStatus = ResourcesPlugin.getWorkspace().save(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            if (saveStatus != null && !saveStatus.isOK()) {
                throw new ResourceException(saveStatus);
            }
        }
        catch (Throwable e) {
            Buckminster.getLogger().error(e, NLS.bind((String)Messages.Error_while_saving_workspace_0, (Object)e.getMessage()), new Object[0]);
        }
        monitor.done();
    }

    public void addProperties(Map<String, String> properties) {
        if (this.m_props == null) {
            this.m_props = new HashMap<String, String>(properties);
        } else {
            this.m_props.putAll(properties);
        }
    }

    public void addProperty(String key, String value) {
        if (this.m_props == null) {
            this.m_props = new HashMap<String, String>();
        }
        this.m_props.put(key, value);
    }

    public boolean isInWorkspace() {
        return this.m_inWorkspace;
    }

    public void setInWorkspace(boolean inWorkspace) {
        this.m_inWorkspace = inWorkspace;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(DEFINE_DESCRIPTOR);
        appendHere.add(PROPERTIES_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        String v;
        if (option.is(DEFINE_DESCRIPTOR)) {
            v = option.getValue();
            Matcher m = DEFINE_PATTERN.matcher(v);
            if (!m.matches()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.Not_a_key_value_string_0, (Object)v));
            }
            String key = m.group(1);
            String value = m.group(2) == null ? "" : m.group(2);
            this.addProperty(key, value);
        }
        if (option.is(PROPERTIES_DESCRIPTOR)) {
            v = option.getValue();
            InputStream input = null;
            try {
                try {
                    URL propsURL = URLUtils.normalizeToURL((String)v);
                    input = DownloadManager.read((URL)propsURL, null);
                    this.addProperties(new BMProperties(input));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.Invalid_URL_or_Path_0, (Object)v));
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
        }
    }

    protected void initWorkspace(IProgressMonitor monitor) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDesc = ws.getDescription();
        wsDesc.setAutoBuilding(false);
        wsDesc.setSnapshotInterval(Long.MAX_VALUE);
        ws.setDescription(wsDesc);
        WorkspaceCommand.saveWorkspace(monitor);
    }

    protected abstract int internalRun(IProgressMonitor var1) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int run(IProgressMonitor monitor) throws Exception {
        int n;
        monitor.beginTask(null, 1000);
        JobBlocker jobBlocker = new JobBlocker();
        jobBlocker.addClassBlock("org.eclipse.core.internal.events.AutoBuildJob");
        jobBlocker.addClassBlock("org.eclipse.jdt.internal.core.search.processing.JobManager$1$ProgressJob");
        Properties sysProps = System.getProperties();
        try {
            if (!this.isInWorkspace()) {
                this.initWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            if (this.m_props != null) {
                Properties newProps = new Properties(sysProps);
                newProps.putAll(this.m_props);
                System.setProperties(newProps);
            }
            jobBlocker.addClassBlock(DelayedSnapshotJob.class);
            n = this.internalRun(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
        }
        catch (Throwable throwable) {
            try {
                if (this.isInWorkspace()) {
                    jobBlocker.release();
                    throw throwable;
                }
                Logger logger = CorePlugin.getLogger();
                logger.debug("Doing full workspace refresh", new Object[0]);
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                catch (Throwable e) {
                    Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
                }
                IJobManager jobManager = Job.getJobManager();
                jobManager.suspend();
                WorkspaceBindingInstallJob.stop();
                Job[] jobArray = jobManager.find(null);
                int n5 = jobArray.length;
                int job = 0;
                while (true) {
                    if (job >= n5) break;
                    Job job2 = jobArray[job];
                    if (job2 instanceof StringPoolJob) {
                        job2.cancel();
                    }
                    ++job;
                }
                Thread joinWait = new Thread(jobManager, logger){
                    private final /* synthetic */ IJobManager val$jobManager;
                    private final /* synthetic */ Logger val$logger;
                    {
                        this.val$jobManager = iJobManager;
                        this.val$logger = logger;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void run() {
                        block4: {
                            try {
                                this.val$jobManager.join(null, (IProgressMonitor)new NullProgressMonitor());
                                break block4;
                            }
                            catch (InterruptedException e) {
                                var5_2 = this.val$jobManager.find(null);
                                var4_3 = var5_2.length;
                                var3_4 = 0;
                                ** while (var3_4 < var4_3)
                            }
lbl-1000:
                            // 1 sources

                            {
                                job = var5_2[var3_4];
                                state = job.getState();
                                if (state == 4) {
                                    this.val$logger.debug("  JOB: %s is still running", new Object[]{job.toString()});
                                }
                                ++var3_4;
                                continue;
                            }
                        }
                    }
                };
                logger.debug("Waiting for jobs to end", new Object[0]);
                joinWait.start();
                joinWait.join(30000L);
                joinWait.interrupt();
                Job[] jobArray3 = jobManager.find(null);
                int n6 = jobArray3.length;
                n5 = 0;
                while (true) {
                    if (n5 >= n6) {
                        jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
                        jobManager.resume();
                        WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                        monitor.done();
                        throw throwable;
                    }
                    Job job3 = jobArray3[n5];
                    job3.cancel();
                    ++n5;
                }
            }
            finally {
                if (this.m_props != null) {
                    System.setProperties(sysProps);
                }
            }
        }
        try {
            if (this.isInWorkspace()) {
                jobBlocker.release();
                return n;
            }
            Logger logger = CorePlugin.getLogger();
            logger.debug("Doing full workspace refresh", new Object[0]);
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            catch (Throwable e) {
                Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
            }
            IJobManager jobManager = Job.getJobManager();
            jobManager.suspend();
            WorkspaceBindingInstallJob.stop();
            Job[] jobArray = jobManager.find(null);
            int n2 = jobArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Job job = jobArray[n3];
                if (job instanceof StringPoolJob) {
                    job.cancel();
                }
                ++n3;
            }
            Thread joinWait = new /* invalid duplicate definition of identical inner class */;
            logger.debug("Waiting for jobs to end", new Object[0]);
            joinWait.start();
            joinWait.join(30000L);
            joinWait.interrupt();
            Job[] jobArray2 = jobManager.find(null);
            int n4 = jobArray2.length;
            n2 = 0;
            while (n2 < n4) {
                Job job = jobArray2[n2];
                job.cancel();
                ++n2;
            }
            jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
            jobManager.resume();
            WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            monitor.done();
            return n;
        }
        finally {
            if (this.m_props != null) {
                System.setProperties(sysProps);
            }
        }
    }
}

