/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.buckminster.core.common.model.CircularExpansionException;
import org.eclipse.buckminster.core.common.model.Constant;
import org.eclipse.buckminster.core.common.model.IProperties;
import org.eclipse.buckminster.core.common.model.ImmutablePropertyException;
import org.eclipse.buckminster.core.common.model.ValueHolder;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.MapUnion;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingProperties<T>
implements IProperties<T> {
    public static final int MAX_NESTING_DEPTH = 64;
    private final Map<String, ValueHolder<T>> m_map;

    public static <T> Map<String, T> createUnmodifiableProperties(Map<String, T> aMap) {
        aMap = aMap == null || aMap.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(new ExpandingProperties<T>(aMap));
        return aMap;
    }

    public static <T> T expand(Map<String, ? extends Object> properties, T value, int nestingLevel) {
        return ExpandingProperties.checkedExpand(properties, value, value, nestingLevel);
    }

    private static <T> T checkedExpand(Map<String, ? extends Object> props, T topValue, T objVal, int recursionGuard) {
        if (!(objVal instanceof String)) {
            return objVal;
        }
        if (recursionGuard > 64) {
            throw new CircularExpansionException((String)topValue);
        }
        String value = (String)objVal;
        StringBuilder bld = null;
        int fragmentStart = 0;
        int top = value.length();
        if (top < 4) {
            return objVal;
        }
        --top;
        int idx = 0;
        while (idx < top) {
            char c = value.charAt(idx);
            if (c == '$') {
                int startPos;
                int endPos;
                if (value.charAt(idx + 1) == '$') {
                    if (bld == null) {
                        bld = new StringBuilder();
                    }
                    if (idx > fragmentStart) {
                        bld.append(value.substring(fragmentStart, idx));
                    }
                    fragmentStart = ++idx;
                } else if (value.charAt(idx + 1) == '{' && idx + 3 < top && (endPos = ExpandingProperties.parsePropertyName(value, startPos = idx + 2, true)) >= 0) {
                    Object propVal;
                    String propKey = value.substring(startPos, endPos);
                    Object object = propVal = props instanceof ExpandingProperties ? ((ExpandingProperties)props).getExpandedProperty(propKey, recursionGuard + 1) : props.get(propKey);
                    if (propVal != null) {
                        if (bld == null) {
                            bld = new StringBuilder();
                        }
                        if (idx > fragmentStart) {
                            bld.append(value.substring(fragmentStart, idx));
                        }
                        bld.append(ExpandingProperties.checkedExpand(props, topValue, propVal, recursionGuard + 1));
                        fragmentStart = endPos + 1;
                    }
                    idx = endPos;
                }
            }
            ++idx;
        }
        if (bld != null) {
            if (fragmentStart < ++top) {
                bld.append(value.substring(fragmentStart, top));
            }
            value = bld.toString();
        }
        return (T)value;
    }

    /*
     * Unable to fully structure code
     */
    private static int parsePropertyName(String source, int startIndex, boolean inResolve) {
        if (source == null) {
            return -1;
        }
        top = source.length();
        if (startIndex >= top) {
            return -1;
        }
        idx = startIndex;
        if (Character.isJavaIdentifierStart(c = source.charAt(idx++))) ** GOTO lbl17
        return -1;
lbl-1000:
        // 1 sources

        {
            last = c;
            if ((c = source.charAt(idx++)) == '.') {
                if (last != '.' && idx != top && (!inResolve || source.charAt(idx) != '}')) continue;
                return -1;
            }
            if (inResolve && c == '}') {
                return idx - 1;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return -1;
lbl17:
            // 3 sources

            ** while (idx < top)
        }
lbl18:
        // 1 sources

        return top;
    }

    public ExpandingProperties() {
        this.m_map = new HashMap<String, ValueHolder<T>>();
    }

    public ExpandingProperties(int size) {
        this.m_map = new HashMap<String, ValueHolder<T>>(size);
    }

    public ExpandingProperties(Map<String, ? extends T> dflts) {
        Map<String, ValueHolder<T>> dfltMap;
        HashMap<String, ValueHolder<T>> overlay = new HashMap<String, ValueHolder<T>>();
        if (dflts == null || dflts.size() == 0) {
            this.m_map = overlay;
            return;
        }
        if (dflts instanceof ExpandingProperties) {
            dfltMap = ((ExpandingProperties)dflts).m_map;
        } else {
            dfltMap = new HashMap<String, ValueHolder<T>>(dflts.size());
            for (Map.Entry<String, T> de : dflts.entrySet()) {
                Constant<T> vh = new Constant<T>(de.getValue());
                vh.setMutable(true);
                dfltMap.put(de.getKey(), vh);
            }
        }
        this.m_map = new MapUnion<String, ValueHolder<T>>(overlay, dfltMap);
    }

    @Override
    public void clear() {
        if (this.m_map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ValueHolder<T>> ee : this.m_map.entrySet()) {
            if (ee.getValue().isMutable()) continue;
            throw new ImmutablePropertyException(ee.getKey());
        }
        this.m_map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new AbstractSet<Map.Entry<String, T>>(){

            @Override
            public Iterator<Map.Entry<String, T>> iterator() {
                return new Iterator<Map.Entry<String, T>>(){
                    private final Iterator<Map.Entry<String, ValueHolder<T>>> m_itor;
                    {
                        this.m_itor = ExpandingProperties.this.m_map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.m_itor.hasNext();
                    }

                    @Override
                    public Map.Entry<String, T> next() {
                        return new EntryWrapper(this.m_itor.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ExpandingProperties.this.m_map.size();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ExpandingProperties && this.m_map.equals(((ExpandingProperties)o).m_map);
    }

    @Override
    public T get(Object key) {
        return key instanceof String ? (T)this.getExpandedProperty((String)key, 0) : null;
    }

    @Override
    public int hashCode() {
        return this.m_map.hashCode();
    }

    @Override
    public Set<String> immutableKeySet() {
        HashSet<String> immutableSet = new HashSet<String>();
        for (Map.Entry<String, ValueHolder<T>> me : this.m_map.entrySet()) {
            if (me.getValue().isMutable()) continue;
            immutableSet.add(me.getKey());
        }
        return immutableSet;
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public boolean isMutable(String key) {
        ValueHolder<T> v = this.m_map.get(key);
        return v == null || v.isMutable();
    }

    @Override
    public Set<String> keySet() {
        return this.m_map.keySet();
    }

    @Override
    public Set<String> mutableKeySet() {
        HashSet<String> mutableSet = new HashSet<String>();
        for (Map.Entry<String, ValueHolder<T>> me : this.m_map.entrySet()) {
            if (!me.getValue().isMutable()) continue;
            mutableSet.add(me.getKey());
        }
        return mutableSet;
    }

    @Override
    public Set<String> overlayKeySet() {
        return this.m_map instanceof MapUnion ? ((MapUnion)this.m_map).overlayKeySet() : this.m_map.keySet();
    }

    @Override
    public T put(String key, T propVal) {
        return this.convertValue(this.setProperty(key, new Constant<T>(propVal)), 0);
    }

    @Override
    public T put(String key, T propVal, boolean mutable) {
        Constant<T> vh = new Constant<T>(propVal);
        vh.setMutable(mutable);
        return this.convertValue(this.setProperty(key, vh), 0);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> t) {
        this.putAll(t, false);
    }

    public void putAll(Map<? extends String, ? extends T> t, boolean mutable) {
        if (t instanceof ExpandingProperties) {
            for (Map.Entry<String, ValueHolder<T>> ee : ((ExpandingProperties)t).m_map.entrySet()) {
                ee.getValue().setMutable(mutable);
                this.setProperty(ee.getKey(), ee.getValue());
            }
        } else {
            for (Map.Entry<String, T> ee : t.entrySet()) {
                Constant<T> vh = new Constant<T>(ee.getValue());
                vh.setMutable(mutable);
                this.setProperty(ee.getKey(), vh);
            }
        }
    }

    @Override
    public T remove(Object key) {
        String strKey;
        ValueHolder<T> vh;
        if (key instanceof String && (vh = this.m_map.remove(strKey = (String)key)) != null) {
            if (!vh.isMutable()) {
                this.m_map.put(strKey, vh);
                throw new ImmutablePropertyException(strKey);
            }
            return vh.checkedGetValue(this, 0);
        }
        return null;
    }

    @Override
    public void setMutable(String key, boolean flag) {
        ValueHolder<T> v = this.m_map.get(key);
        if (v != null) {
            v.setMutable(flag);
        }
    }

    public ValueHolder<T> setProperty(String key, ValueHolder<T> propertyHolder) {
        ValueHolder<T> v = this.m_map.put(key, propertyHolder);
        if (v != null && !v.isMutable() && !v.equals(propertyHolder)) {
            this.m_map.put(key, v);
            throw new ImmutablePropertyException(key);
        }
        return v;
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BMProperties.store(this, out, comments);
    }

    @Override
    public boolean supportsMutability() {
        return true;
    }

    @Override
    public Collection<T> values() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<ValueHolder<T>> m_itor;
                    {
                        this.m_itor = ExpandingProperties.this.m_map.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.m_itor.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value = ExpandingProperties.this.convertValue(this.m_itor.next(), 0);
                        if (value != null) {
                            value = ExpandingProperties.expand(ExpandingProperties.this, value, 0);
                        }
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ExpandingProperties.this.m_map.size();
            }
        };
    }

    void emitProperties(ContentHandler handler, String namespace, String prefix, boolean includeDefaults) throws SAXException {
        String plName = "property";
        String pqName = Utils.makeQualifiedName((String)prefix, (String)plName);
        String pelName = "propertyElement";
        String peqName = Utils.makeQualifiedName((String)prefix, (String)pelName);
        AttributesImpl attrs = new AttributesImpl();
        TreeSet<String> sorted = new TreeSet<String>();
        if (includeDefaults) {
            for (String key : this.keySet()) {
                sorted.add(key);
            }
        } else {
            for (String name : this.overlayKeySet()) {
                sorted.add(name);
            }
        }
        for (String name : sorted) {
            String sysValue;
            ValueHolder<T> value = this.m_map.get(name);
            if (value == null || includeDefaults && value instanceof Constant && (sysValue = System.getProperty(name)) != null && sysValue.equals(value)) continue;
            attrs.clear();
            Utils.addAttribute((AttributesImpl)attrs, (String)"key", (String)name);
            if (value.isMutable()) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"mutable", (String)"true");
            }
            if (value instanceof Constant) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"value", (String)((Object)value).toString());
                handler.startElement(namespace, plName, pqName, attrs);
                handler.endElement(namespace, plName, pqName);
                continue;
            }
            handler.startElement(namespace, pelName, peqName, attrs);
            value.toSax(handler, namespace, prefix, value.getDefaultTag());
            handler.endElement(namespace, pelName, peqName);
        }
    }

    T getExpandedProperty(String key, int recursionGuard) {
        return this.convertValue(this.m_map.get(key), recursionGuard);
    }

    private T convertValue(ValueHolder<T> vh, int recursionGuard) {
        return vh == null ? null : (T)vh.checkedGetValue(this, recursionGuard);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryWrapper
    implements Map.Entry<String, T> {
        private final Map.Entry<String, ValueHolder<T>> m_entry;

        public EntryWrapper(Map.Entry<String, ValueHolder<T>> entry) {
            this.m_entry = entry;
        }

        @Override
        public String getKey() {
            return this.m_entry.getKey();
        }

        @Override
        public T getValue() {
            Object value = ExpandingProperties.this.convertValue(this.m_entry.getValue(), 0);
            if (value != null) {
                value = ExpandingProperties.expand(ExpandingProperties.this, value, 0);
            }
            return value;
        }

        @Override
        public synchronized T setValue(T value) {
            String key = this.m_entry.getKey();
            ValueHolder vh = this.m_entry.getValue();
            Constant constant = new Constant(value);
            if (vh != null && !vh.isMutable() && !vh.equals((Object)constant)) {
                throw new ImmutablePropertyException(key);
            }
            this.m_entry.setValue(constant);
            return ExpandingProperties.this.convertValue(vh, 0);
        }
    }
}

