/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.buckminster.core.common.model.AbstractSplit;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSplit
extends AbstractSplit {
    public GroupSplit(String pattern) {
        super(pattern);
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)"style", (String)"group");
    }

    @Override
    protected List<String> checkedGetValues(Map<String, ? extends Object> properties, int recursionGuard) {
        String source = this.checkedGetSourceValue(properties, recursionGuard);
        Matcher m = this.getPattern().matcher(source);
        int nGroups = m.groupCount();
        ArrayList<String> result = new ArrayList<String>(nGroups);
        int idx = 0;
        while (idx < nGroups) {
            result.add(m.group(nGroups + 1));
            ++idx;
        }
        return result;
    }
}

