/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.ValueHolderFilter;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replace
extends ValueHolderFilter {
    public static final String TAG = "replace";
    public static final String MATCH_TAG = "match";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_REPLACEMENT = "replacement";
    public static final String ATTR_QUOTE_PATTERN = "quotePattern";
    private final ArrayList<Match> m_matchers = new ArrayList();

    public void addMatch(Match match) {
        this.m_matchers.add(match);
    }

    @Override
    public String checkedGetValue(Map<String, ? extends Object> props, int recursionGuard) {
        String resolved = this.checkedGetSourceValue(props, recursionGuard);
        if (resolved == null || "".equals(resolved)) {
            return "";
        }
        for (Match match : this.m_matchers) {
            String result = match.match(resolved);
            if (result == null) continue;
            return result;
        }
        return resolved;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.m_matchers.equals(((Replace)((Object)o)).m_matchers);
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + this.m_matchers.hashCode();
        return hc;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_matchers.size() == 1) {
            this.m_matchers.get(0).addAttributes(attrs);
        }
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        int top = this.m_matchers.size();
        if (top > 1) {
            int idx = 0;
            while (idx < top) {
                Match match = this.m_matchers.get(idx);
                match.toSax(handler, namespace, prefix, match.getDefaultTag());
                ++idx;
            }
        }
    }

    public static final class Match
    extends AbstractSaxableElement {
        private final Pattern m_pattern;
        private final String m_patternString;
        private final String m_replacement;
        private final boolean m_quotePattern;

        public Match(String pattern, String replacement, boolean quotePattern) {
            this.m_patternString = pattern;
            this.m_quotePattern = quotePattern;
            this.m_replacement = replacement;
            if (quotePattern) {
                pattern = Pattern.quote(pattern);
            }
            this.m_pattern = Pattern.compile(pattern);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Match)) {
                return false;
            }
            return this.m_quotePattern == ((Match)((Object)o)).m_quotePattern && this.m_patternString.equals(((Match)((Object)o)).m_patternString) && this.m_replacement.equals(((Match)((Object)o)).m_replacement);
        }

        public String getDefaultTag() {
            return Replace.MATCH_TAG;
        }

        public int hashCode() {
            int hc = this.m_patternString.hashCode();
            hc = 37 * hc + this.m_replacement.hashCode();
            hc = 37 * hc + (this.m_quotePattern ? 17 : 0);
            return hc;
        }

        protected void addAttributes(AttributesImpl attrs) throws SAXException {
            Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_PATTERN, (String)this.m_patternString);
            Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_REPLACEMENT, (String)this.m_replacement);
            if (this.m_quotePattern) {
                Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_QUOTE_PATTERN, (String)"true");
            }
        }

        String match(String resolved) {
            Matcher matcher = this.m_pattern.matcher(resolved);
            if (matcher.find()) {
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, this.m_replacement);
                } while (matcher.find());
                matcher.appendTail(sb);
                return sb.toString();
            }
            return null;
        }
    }
}

