/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec;

import java.io.File;
import java.util.Map;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathGroup {
    public static final PathGroup[] EMPTY_ARRAY = new PathGroup[0];
    private final IPath m_base;
    private final IPath[] m_paths;

    public PathGroup(IPath base, IPath[] paths) {
        if (base == null) {
            throw new IllegalArgumentException(Messages.Base_cannot_be_null);
        }
        this.m_base = base;
        this.m_paths = paths;
    }

    public void appendRelativeFiles(Map<String, Long> fileNames) {
        int idx = this.m_paths.length;
        if (idx == 0) {
            FileUtils.appendRelativeFiles(this.m_base.toFile(), fileNames);
            return;
        }
        File baseDir = this.m_base.toFile();
        while (--idx >= 0) {
            FileUtils.appendRelativeFiles(baseDir, this.m_paths[idx].toFile(), fileNames);
        }
    }

    public boolean containsPath(IPath path) {
        boolean isPrefix;
        if (path == null) {
            return false;
        }
        boolean isCompletelyEmpty = this.m_base.isEmpty() && this.m_base.getDevice() == null;
        boolean bl = isPrefix = isCompletelyEmpty || this.m_base.isPrefixOf(path);
        if (!isPrefix) {
            return false;
        }
        IPath relPath = path;
        if (!isCompletelyEmpty) {
            relPath = path.removeFirstSegments(this.m_base.segmentCount()).setDevice(null);
        }
        IPath[] iPathArray = this.m_paths;
        int n = this.m_paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath cmpPath;
            IPath rel = iPathArray[n2];
            IPath iPath = cmpPath = rel.isAbsolute() ? path : relPath;
            if (rel.equals((Object)cmpPath) || rel.hasTrailingSeparator() && rel.isPrefixOf(cmpPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void copyTo(IPath destination, IProgressMonitor monitor) throws CoreException {
        if (!destination.isAbsolute()) {
            throw new IllegalArgumentException(Messages.Destination_must_be_absolute);
        }
        if (!this.m_base.isAbsolute()) {
            throw new IllegalArgumentException(Messages.Source_must_be_absolute);
        }
        File destDir = destination.toFile().getAbsoluteFile();
        File baseDir = this.m_base.toFile().getAbsoluteFile();
        int idx = this.m_paths.length;
        if (idx == 0) {
            if (baseDir.isDirectory()) {
                FileUtils.deepCopy(baseDir, destDir, ConflictResolution.UPDATE, monitor);
            }
            return;
        }
        monitor.beginTask(null, idx * 100);
        while (--idx >= 0) {
            String fileName = null;
            File basedDestDir = null;
            IPath path = this.m_paths[idx];
            if (!path.hasTrailingSeparator()) {
                File sourceFile;
                fileName = path.lastSegment();
                if (path.isAbsolute() || path.segmentCount() == 1) {
                    basedDestDir = destDir;
                    if (!path.isAbsolute()) {
                        path = this.m_base.append(path);
                    }
                } else {
                    basedDestDir = destination.append(path.removeLastSegments(1)).toFile();
                }
                if (!(sourceFile = path.toFile()).exists()) continue;
                FileUtils.prepareDestination(basedDestDir, ConflictResolution.UPDATE, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                FileUtils.copyFile(sourceFile, basedDestDir, fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
                continue;
            }
            if (path.isAbsolute()) {
                basedDestDir = destDir;
            } else {
                basedDestDir = destination.append(path).toFile();
                path = this.m_base.append(path);
            }
            File sourceDir = path.toFile();
            if (!sourceDir.exists()) continue;
            FileUtils.deepCopy(sourceDir, basedDestDir, ConflictResolution.UPDATE, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
        }
        monitor.done();
    }

    public final IPath getBase() {
        return this.m_base;
    }

    public long getFirstModified(int expectedCount, int[] fileCount) {
        int idx = this.m_paths.length;
        if (idx == 0) {
            return FileUtils.getFirstModified(this.m_base.toFile(), expectedCount, fileCount);
        }
        if (idx > 1 && expectedCount > 0) {
            expectedCount = -1;
        }
        long firstMod = Long.MAX_VALUE;
        while (--idx >= 0) {
            long modTime;
            IPath absPath = this.m_paths[idx];
            if (!absPath.isAbsolute()) {
                absPath = this.m_base.append(absPath);
            }
            if ((modTime = FileUtils.getFirstModified(absPath.toFile(), expectedCount, fileCount)) >= firstMod) continue;
            firstMod = modTime;
            if (modTime == 0L) break;
        }
        return firstMod;
    }

    public long getLastModified(long threshold, int[] fileCount) {
        int idx = this.m_paths.length;
        if (idx == 0) {
            return FileUtils.getLastModified(this.m_base.toFile(), threshold, fileCount);
        }
        long lastMod = 0L;
        int count = 0;
        int[] countBin = new int[1];
        while (--idx >= 0) {
            IPath absPath = this.m_paths[idx];
            if (!absPath.isAbsolute()) {
                absPath = this.m_base.append(absPath);
            }
            countBin[0] = 0;
            long modTime = FileUtils.getLastModified(absPath.toFile(), threshold, countBin);
            count += countBin[0];
            if (modTime <= lastMod) continue;
            lastMod = modTime;
            if (modTime > threshold) break;
        }
        fileCount[0] = count;
        return lastMod;
    }

    public final IPath[] getPaths() {
        return this.m_paths;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_base.toPortableString());
        bld.append('{');
        int top = this.m_paths.length;
        if (top > 0) {
            bld.append(this.m_paths[0]);
            int idx = 1;
            while (idx < top) {
                bld.append(',');
                bld.append(this.m_paths[idx]);
                ++idx;
            }
        }
        bld.append('}');
        return bld.toString();
    }
}

