/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBuilder
extends TopLevelAttributeBuilder
implements IAction {
    private String m_actorName;
    private final ExpandingProperties<String> m_actorProperties = new ExpandingProperties();
    private boolean m_always = false;
    private boolean m_assignConsoleSupport = true;
    private final PrerequisitesBuilder m_prerequisitesBuilder;
    private String m_productAlias;
    private IPath m_productBase;
    private int m_productFileCount = -1;
    private final HashSet<IPath> m_productPaths = new HashSet();
    private final ExpandingProperties<String> m_properties = new ExpandingProperties();
    private UpToDatePolicy m_upToDatePolicy = UpToDatePolicy.DEFAULT;

    ActionBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
        this.m_prerequisitesBuilder = new PrerequisitesBuilder(cspecBuilder);
    }

    public void addActorProperty(String key, String propVal, boolean mutable) {
        this.m_actorProperties.put(key, propVal, mutable);
    }

    @Override
    public void addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        this.m_prerequisitesBuilder.addPrerequisite(prerequisite);
    }

    public ArtifactBuilder addProductArtifact(String name, boolean publ, IPath output) throws AttributeAlreadyDefinedException {
        CSpecBuilder cspecBuilder = this.getCSpecBuilder();
        ActionArtifactBuilder bld = cspecBuilder.createActionArtifactBuilder();
        bld.setActionName(this.getName());
        bld.setName(name);
        bld.setPublic(publ);
        bld.setBase(output);
        cspecBuilder.addAttribute(bld);
        return bld;
    }

    @Deprecated
    public ArtifactBuilder addProductArtifact(String name, boolean publ, String type, IPath output) throws AttributeAlreadyDefinedException {
        return this.addProductArtifact(name, publ, output);
    }

    public void addProductPath(IPath path) {
        this.m_productPaths.add(path);
    }

    public void addProperty(String key, String propVal, boolean mutable) {
        this.m_properties.put(key, propVal, mutable);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_actorName = null;
        this.m_always = false;
        this.m_assignConsoleSupport = true;
        this.m_actorProperties.clear();
        this.m_prerequisitesBuilder.clear();
        this.m_productPaths.clear();
        this.m_properties.clear();
        this.m_productAlias = null;
        this.m_productBase = null;
        this.m_upToDatePolicy = UpToDatePolicy.DEFAULT;
        this.m_productFileCount = -1;
    }

    @Override
    public Action createAttribute() {
        return new Action(this);
    }

    @Override
    public String getActorName() {
        return this.m_actorName;
    }

    public ExpandingProperties<String> getActorProperties() {
        return this.m_actorProperties;
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new ActionBuilder(specBuilder);
    }

    public PrerequisiteBuilder getPrerequisite(String prerequisteName) {
        return this.m_prerequisitesBuilder.getPrerequisite(prerequisteName);
    }

    @Override
    public Group getPrerequisiteGroup() {
        return null;
    }

    @Override
    public List<? extends IPrerequisite> getPrerequisites() {
        return this.getPrerequisitesBuilder().getPrerequisites();
    }

    public PrerequisitesBuilder getPrerequisitesBuilder() {
        return this.m_prerequisitesBuilder;
    }

    @Override
    public String getProductAlias() {
        return this.m_productAlias;
    }

    public ArtifactBuilder getProductArtifact(String name) {
        ArtifactBuilder bld = this.getCSpecBuilder().getArtifactBuilder(name);
        return bld instanceof ActionArtifactBuilder ? bld : null;
    }

    @Override
    public IPath getProductBase() {
        return this.m_productBase;
    }

    @Override
    public int getProductFileCount() {
        return this.m_productFileCount;
    }

    public HashSet<IPath> getProductPaths() {
        return this.m_productPaths;
    }

    public ExpandingProperties<String> getProperties() {
        return this.m_properties;
    }

    @Override
    public UpToDatePolicy getUpToDatePolicy() {
        return this.m_upToDatePolicy;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        IAction action = (IAction)attribute;
        super.initFrom(action);
        this.m_actorName = action.getActorName();
        this.m_actorProperties.putAll(action.getActorProperties(), true);
        this.m_always = action.isAlways();
        this.m_assignConsoleSupport = action.isAssignConsoleSupport();
        this.m_prerequisitesBuilder.initFrom(action.getPrerequisiteGroup());
        this.m_productAlias = action.getProductAlias();
        this.m_productBase = action.getProductBase();
        this.m_upToDatePolicy = action.getUpToDatePolicy();
        this.m_productFileCount = action.getProductFileCount();
        this.m_productPaths.addAll(action.getProductPaths());
        this.m_properties.putAll(action.getProperties(), true);
    }

    @Override
    public boolean isAlways() {
        return this.m_always;
    }

    @Override
    public boolean isAssignConsoleSupport() {
        return this.m_assignConsoleSupport;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public void removePrerequisite(String prerequisteName) {
        this.m_prerequisitesBuilder.removePrerequisite(prerequisteName);
    }

    public void removeProductPath(IPath path) {
        this.m_productPaths.remove(path);
    }

    public void setActorName(String actorName) {
        this.m_actorName = actorName;
    }

    public void setAlways(boolean always) {
        this.m_always = always;
    }

    public void setAssignConsoleSupport(boolean assignConsoleSupport) {
        this.m_assignConsoleSupport = assignConsoleSupport;
    }

    public void setPrerequisites(Group prerequisites) {
        this.m_prerequisitesBuilder.initFrom(prerequisites);
    }

    public void setPrerequisitesAlias(String alias) {
        this.m_prerequisitesBuilder.setName(alias);
    }

    public void setPrerequisitesRebase(IPath rebase) {
        this.m_prerequisitesBuilder.setPrerequisiteRebase(rebase);
    }

    public void setProductAlias(String productAlias) {
        this.m_productAlias = productAlias;
    }

    public void setProductBase(IPath productBase) {
        this.m_productBase = productBase == null ? null : productBase.addTrailingSeparator();
    }

    public void setProductFileCount(int productFileCount) {
        this.m_productFileCount = productFileCount;
    }

    public void setUpToDatePolicy(UpToDatePolicy upToDatePolicy) {
        this.m_upToDatePolicy = upToDatePolicy;
    }
}

