/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.IArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.MissingPathException;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Artifact;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactBuilder
extends TopLevelAttributeBuilder
implements IArtifact {
    private IPath m_base;
    private final HashSet<IPath> m_paths = new HashSet();

    ArtifactBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public void addPath(IPath path) throws PathAlreadyDefinedException {
        if (this.m_paths.contains(path)) {
            throw new PathAlreadyDefinedException(this.getCSpecName(), this.getName(), path);
        }
        this.m_paths.add(path);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_base = null;
        this.m_paths.clear();
    }

    @Override
    public Artifact createAttribute() {
        return new Artifact(this);
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new ArtifactBuilder(specBuilder);
    }

    @Override
    public IPath getBase() {
        return this.m_base;
    }

    @Override
    public Set<IPath> getPaths() {
        return this.m_paths;
    }

    @Override
    @Deprecated
    public String getType() {
        return null;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute);
        IArtifact artifact = (IArtifact)attribute;
        this.m_base = artifact.getBase();
        this.m_paths.addAll(artifact.getPaths());
    }

    public void removePath(IPath path) throws MissingPathException {
        if (!this.m_paths.contains(path)) {
            throw new MissingPathException(this.getCSpecName(), this.getName(), path);
        }
        this.m_paths.remove(path);
    }

    public void setBase(IPath base) {
        this.m_base = base == null ? null : base.addTrailingSeparator();
    }

    @Deprecated
    public void setType(String type) {
    }
}

