/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.osgi.filter.Filter;

public abstract class TopLevelAttributeBuilder
extends AttributeBuilder {
    private boolean m_public = false;

    TopLevelAttributeBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public final void addExternalPrerequisite(String name, String type, String attr) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(name, type, attr, null, null));
    }

    public final void addLocalPrerequisite(AttributeBuilder attr) throws PrerequisiteAlreadyDefinedException {
        this.addLocalPrerequisite(attr.getName());
    }

    public final void addLocalPrerequisite(String attr) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(null, null, attr, null, null));
    }

    public final void addLocalPrerequisite(String attr, String alias) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(null, null, attr, alias, null));
    }

    public final void addLocalPrerequisite(String attr, String alias, Filter filter) throws PrerequisiteAlreadyDefinedException {
        this.addPrerequisite(this.createPrerequisite(null, null, attr, alias, filter));
    }

    public void addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        super.clear();
        this.m_public = false;
    }

    public abstract Attribute createAttribute();

    public PrerequisiteBuilder createPrerequisiteBuilder() {
        return new PrerequisiteBuilder(this);
    }

    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute);
        this.m_public = attribute.isPublic();
    }

    public boolean isPublic() {
        return this.m_public;
    }

    public void removePrerequisite(IPrerequisite pq) {
        this.removePrerequisite(pq.toString());
    }

    public void removePrerequisite(String prerequisiteName) {
        throw new UnsupportedOperationException();
    }

    public void setPublic(boolean flag) {
        this.m_public = flag;
    }

    private PrerequisiteBuilder createPrerequisite(String component, String type, String name, String alias, Filter filter) {
        PrerequisiteBuilder bld = this.createPrerequisiteBuilder();
        bld.setComponentName(component);
        bld.setComponentType(type);
        bld.setName(name);
        bld.setAlias(alias);
        bld.setFilter(filter);
        return bld;
    }
}

