/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Artifact;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionArtifact
extends Artifact
implements IActionArtifact {
    private final String m_actionName;
    private final String m_alias;

    public ActionArtifact(ActionArtifactBuilder builder) {
        super(builder);
        this.m_actionName = builder.getActionName();
        this.m_alias = builder.getAlias();
    }

    public final Action getAction() throws MissingAttributeException {
        return (Action)this.getCSpec().getRequiredAttribute(this.m_actionName);
    }

    @Override
    public String getActionName() {
        return this.m_actionName;
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    @Override
    public boolean isEnabled(IModelCache ctx) throws CoreException {
        return this.getAction().isEnabled(ctx);
    }

    @Override
    public boolean isProducedByActions(IModelCache ctx) {
        return true;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_alias != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"alias", (String)this.m_alias);
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createActionArtifactBuilder();
    }

    @Override
    protected IPath getExpandedBase(Map<String, ? extends Object> local) throws CoreException {
        return this.getAction().getExpandedBase(this.getBase(), local);
    }
}

