/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequestConflictException;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRequest
extends ComponentName
implements IComponentRequest {
    public static final String TAG = "component";
    public static final String ATTR_VERSION_DESIGNATOR = "versionDesignator";
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String ATTR_FILTER = "filter";
    private final VersionRange m_versionRange;
    private final Filter m_filter;
    public static final Filter P2_OPTIONAL_FILTER;
    public static final String FILTER_ECLIPSE_P2_OPTIONAL = "(!(eclipse.p2.optional=false))";

    static {
        try {
            P2_OPTIONAL_FILTER = FilterFactory.newInstance((String)FILTER_ECLIPSE_P2_OPTIONAL);
        }
        catch (InvalidSyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public ComponentRequest(ComponentRequestBuilder bld) {
        super(bld.getName(), bld.getComponentTypeID());
        VersionRange vr = bld.getVersionRange();
        if (vr != null && vr.equals((Object)VersionRange.emptyRange)) {
            vr = null;
        }
        this.m_versionRange = vr;
        this.m_filter = bld.getFilter();
    }

    public ComponentRequest(String name, String componentType, String versionRangeStr, String versionTypeId) throws CoreException {
        this(name, componentType, versionRangeStr, versionTypeId, null);
    }

    public ComponentRequest(String name, String componentType, String versionRangeStr, String versionTypeId, Filter filter) throws CoreException {
        this(name, componentType, VersionHelper.createRange(versionTypeId, versionRangeStr), filter);
    }

    public ComponentRequest(String name, String componentType, VersionRange versionRange) {
        this(name, componentType, versionRange, null);
    }

    public ComponentRequest(String name, String componentType, VersionRange versionRange, Filter filter) {
        super(name, componentType);
        if (versionRange != null && versionRange.equals((Object)VersionRange.emptyRange)) {
            versionRange = null;
        }
        this.m_versionRange = versionRange;
        this.m_filter = filter;
    }

    public void appendViewName(StringBuilder bld) {
        bld.append(this.getName());
        String componentType = this.getComponentTypeID();
        if (componentType != null) {
            bld.append(':');
            bld.append(componentType);
        }
        if (this.m_filter != null) {
            bld.append(this.m_filter);
        }
    }

    @Override
    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.getComponentTypeID() != null && !this.getComponentTypeID().equals(id.getComponentTypeID()) || this.m_versionRange != null && !this.m_versionRange.isIncluded(id.getVersion()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return super.equals(o) && Trivial.equalsAllowNull((Object)this.m_versionRange, (Object)((ComponentRequest)o).m_versionRange) && Trivial.equalsAllowNull((Object)this.m_filter, (Object)((ComponentRequest)o).m_filter);
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Filter getFilter() {
        return this.m_filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.m_versionRange != null) {
            p.put("buckminster.version.designator", this.m_versionRange.toString());
        }
        return p;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.m_versionRange;
    }

    public String getViewName() {
        StringBuilder bld = new StringBuilder();
        this.appendViewName(bld);
        return bld.toString();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.m_versionRange == null ? 0 : this.m_versionRange.hashCode());
        return 31 * hash + (this.m_filter == null ? 0 : this.m_filter.hashCode());
    }

    public boolean isEnabled(Map<String, ? extends Object> properties) {
        return this.m_filter == null || this.m_filter.matchCase(properties);
    }

    public boolean isOptional() {
        return this.m_filter != null && this.m_filter.toString().contains(FILTER_ECLIPSE_P2_OPTIONAL);
    }

    public ComponentRequest mergeDesignator(ComponentRequest that) throws CoreException {
        if (!Trivial.equalsAllowNull((Object)this.getName(), (Object)that.getName())) {
            throw new ComponentRequestConflictException(this, that);
        }
        int cmp = 0;
        VersionRange thisVD = this.getVersionRange();
        VersionRange thatVD = that.getVersionRange();
        VersionRange mergedVD = null;
        if (thisVD == null) {
            if (thatVD != null) {
                cmp = 1;
                mergedVD = thatVD;
            }
        } else if (thatVD == null) {
            cmp = -1;
            mergedVD = thisVD;
        } else {
            mergedVD = thisVD.intersect(thatVD);
            if (mergedVD == null) {
                throw new ComponentRequestConflictException(this, that);
            }
            if (mergedVD.equals((Object)thisVD)) {
                if (!mergedVD.equals((Object)thatVD)) {
                    cmp = -1;
                }
            } else {
                cmp = mergedVD.equals((Object)thatVD) ? 1 : 2;
            }
        }
        String thisCType = this.getComponentTypeID();
        String thatCType = that.getComponentTypeID();
        String mergedCType = null;
        if (thisCType == null) {
            if (thatCType != null) {
                if (cmp == 0) {
                    cmp = 1;
                }
                mergedCType = thatCType;
            }
        } else {
            if (thatCType != null) {
                if (!thisCType.equals(thatCType)) {
                    throw new ComponentRequestConflictException(this, that);
                }
            } else if (cmp == 0) {
                cmp = -1;
            }
            mergedCType = thisCType;
        }
        Filter thisFilter = this.getFilter();
        Filter thatFilter = that.getFilter();
        boolean thisOptional = this.isOptional();
        boolean thatOptional = that.isOptional();
        Filter mergedFilter = null;
        if (!Trivial.equalsAllowNull((Object)thisFilter, (Object)thatFilter)) {
            if (thisOptional != thatOptional) {
                throw new ComponentRequestConflictException(this, that);
            }
            if (thisFilter != null && thatFilter != null) {
                mergedFilter = thisFilter.addFilterWithOr(thatFilter);
            }
        } else {
            mergedFilter = thisFilter;
        }
        if (thisOptional) {
            if (!thatOptional) {
                if (cmp == -1 || cmp == 2) {
                    throw new ComponentRequestConflictException(this, that);
                }
                return that;
            }
        } else if (thatOptional) {
            if (cmp > 0) {
                throw new ComponentRequestConflictException(this, that);
            }
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thisVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thisCType) && Trivial.equalsAllowNull((Object)thisFilter, (Object)mergedFilter)) {
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thatVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thatCType) && Trivial.equalsAllowNull((Object)thatFilter, (Object)mergedFilter)) {
            return that;
        }
        return new ComponentRequest(this.getName(), mergedCType, mergedVD, mergedFilter);
    }

    @Override
    public ComponentName toPureComponentName() {
        return new ComponentName(this);
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        if (this.m_versionRange != null) {
            bld.append('/');
            bld.append(VersionHelper.getHumanReadable(this.m_versionRange));
        }
        if (this.m_filter != null) {
            bld.append(this.m_filter);
        }
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_versionRange != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_DESIGNATOR, (String)this.m_versionRange.toString());
        }
        if (this.m_filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.m_filter.toString());
        }
    }
}

