/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ComponentRequestHandler
extends ExtensionAwareHandler {
    public static final String TAG = "component";
    private final ComponentRequestBuilder m_builder;

    public ComponentRequestHandler(AbstractHandler parent, ComponentRequestBuilder builder) {
        super(parent);
        this.m_builder = builder;
    }

    public ComponentRequestBuilder getBuilder() {
        return this.m_builder;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_builder.clear();
        this.m_builder.setName(this.getStringValue(attrs, "name"));
        this.m_builder.setComponentTypeID(this.getComponentType(attrs));
        try {
            this.m_builder.setVersionRange(VersionHelper.parseVersionRangeAttributes(attrs));
        }
        catch (CoreException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        String filter = ComponentRequestHandler.getOptionalStringValue((Attributes)attrs, (String)"filter");
        if (filter != null) {
            try {
                this.m_builder.setFilter(FilterFactory.newInstance((String)filter));
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
    }
}

