/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class DateAndTimeUtils {
    public static final String ISO_8601Pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final DateFormat ISO_8601Format;
    public static final TimeZone UTC;
    public static final String[] commonFormats;
    public static final DateFormat[] commonFormatters;
    private static final long SANITY_THRESHOLD = 2086587392L;

    static {
        commonFormats = new String[]{"yyyyMMddHHmm", "yyyyMMdd-HHmm", "yyyyMMdd"};
        ISO_8601Format = new SimpleDateFormat(ISO_8601Pattern);
        UTC = TimeZone.getTimeZone("UTC");
        ISO_8601Format.setCalendar(Calendar.getInstance(UTC));
        int idx = commonFormats.length;
        commonFormatters = new DateFormat[idx];
        while (--idx >= 0) {
            SimpleDateFormat dm = new SimpleDateFormat(commonFormats[idx]);
            dm.setTimeZone(UTC);
            dm.setLenient(false);
            DateAndTimeUtils.commonFormatters[idx] = dm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date fromISOFormat(String dateStr) throws ParseException {
        if (dateStr == null) {
            return null;
        }
        DateFormat dateFormat = ISO_8601Format;
        synchronized (dateFormat) {
            return ISO_8601Format.parse(dateStr);
        }
    }

    public static Date fromString(String timestampStr) throws ParseException {
        int idx = 0;
        while (idx < commonFormatters.length) {
            try {
                return DateAndTimeUtils.parseSaneDate(commonFormatters[idx], timestampStr);
            }
            catch (ParseException parseException) {
                ++idx;
            }
        }
        throw new ParseException(NLS.bind((String)Messages.Unable_to_parse_0_as_timestamp, (Object)timestampStr), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISOFormat(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = ISO_8601Format;
        synchronized (dateFormat) {
            return ISO_8601Format.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseSaneDate(DateFormat mf, String str) throws ParseException {
        Date dt;
        long now = System.currentTimeMillis();
        DateFormat dateFormat = mf;
        synchronized (dateFormat) {
            dt = mf.parse(str);
        }
        long tm = dt.getTime();
        if (tm > now + 2086587392L || tm < now - 2086587392L) {
            throw new ParseException(Messages.Bogus, 0);
        }
        return dt;
    }
}

