/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class FibonacciMonitorWrapper
extends ProgressMonitorWrapper {
    private int m_multiplier = 65536;
    private double m_totalWork = 0.0;
    private double m_worked = 0.0;
    private static final double s_goldenRatio = 1.6181818181818182;

    public FibonacciMonitorWrapper(IProgressMonitor monitor) {
        super(monitor);
    }

    public void beginTask(String name, int totalWork) {
        this.m_totalWork = totalWork *= this.m_multiplier;
        this.getWrappedProgressMonitor().beginTask(name, totalWork);
    }

    public void internalWorked(double work) {
        double attempt = work * (double)this.m_multiplier;
        while (this.m_worked + attempt > this.m_totalWork / 1.6181818181818182 && this.m_multiplier > 1) {
            this.m_multiplier >>= 1;
            this.m_totalWork -= this.m_worked;
            this.m_worked = 0.0;
            attempt = work * (double)this.m_multiplier;
        }
        this.m_worked += attempt;
        if (this.m_worked >= this.m_totalWork) {
            attempt = 0.0;
            this.m_worked = this.m_totalWork;
        }
        this.getWrappedProgressMonitor().internalWorked(attempt);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }
}

