/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ProgressStatistics {
    public static final AmountConverter TRIVIAL_CONVERTER = new TrivialConverter();
    public static final AmountConverter FILESIZE_CONVERTER = new FileSizeConverter();
    public static final int DEFAULT_REPORT_INTERVAL = 1000;
    public static final int DEFAULT_RECENT_SPEED_INTERVAL = 5000;
    public static final int DEFULAT_RECENT_SPEED_RESOLUTION = 1000;
    private long m_current = 0L;
    private long m_total = -1L;
    private Date m_startTime = new Date();
    private AmountConverter m_converter = TRIVIAL_CONVERTER;
    private Date m_lastReportTime = null;
    private int m_reportInterval = 1000;
    private int m_recentSpeedInterval = 5000;
    private int m_recentSpeedResolution = 1000;
    private SortedMap<Long, Long> m_recentSpeedMap = new TreeMap<Long, Long>();
    private long m_recentSpeedMapKey = 0L;

    public ProgressStatistics() {
    }

    public ProgressStatistics(long total) {
        this();
        this.m_total = total;
    }

    public long getAverageSpeed() {
        long dur = this.getDuration();
        if (dur >= 1000L) {
            return this.m_current / (dur / 1000L);
        }
        return 0L;
    }

    public long getDuration() {
        return new Date().getTime() - this.m_startTime.getTime();
    }

    public double getPercentage() {
        if (this.m_total > 0L) {
            return (double)this.m_current / (double)this.m_total;
        }
        return 0.0;
    }

    public synchronized long getRecentSpeed() {
        this.removeObsoleteRecentSpeedData(this.getDuration() / (long)this.m_recentSpeedResolution);
        long dur = 0L;
        long amount = 0L;
        SortedMap<Long, Long> relevantData = this.m_recentSpeedMap.headMap(this.m_recentSpeedMapKey);
        for (Map.Entry<Long, Long> entry : relevantData.entrySet()) {
            dur += (long)this.m_recentSpeedResolution;
            amount += entry.getValue().longValue();
        }
        if (dur >= 1000L) {
            return amount / (dur / 1000L);
        }
        return 0L;
    }

    public int getRecentSpeedInterval() {
        return this.m_recentSpeedInterval;
    }

    public int getRecentSpeedResolution() {
        return this.m_recentSpeedResolution;
    }

    public int getReportInterval() {
        return this.m_reportInterval;
    }

    public void increase(long inc) {
        this.registerRecentSpeed(this.getDuration() / (long)this.m_recentSpeedResolution, inc);
        this.m_current += inc;
    }

    private synchronized void registerRecentSpeed(long key, long inc) {
        Long keyL = key;
        Long currentValueL = (Long)this.m_recentSpeedMap.get(keyL);
        long currentValue = 0L;
        if (currentValueL != null) {
            currentValue = currentValueL;
        }
        this.m_recentSpeedMap.put(keyL, inc + currentValue);
        if (this.m_recentSpeedMapKey != key) {
            this.m_recentSpeedMapKey = key;
            this.removeObsoleteRecentSpeedData(key);
        }
    }

    private synchronized void removeObsoleteRecentSpeedData(long lastKey) {
        long threshold = lastKey - (long)(this.m_recentSpeedInterval / this.m_recentSpeedResolution);
        this.m_recentSpeedMap.headMap(threshold).clear();
    }

    public String report() {
        return String.valueOf(this.m_converter.convert(this.m_current)) + (this.m_total != -1L ? " of " + this.m_converter.convert(this.m_total) : "") + " at " + this.m_converter.convert(this.getRecentSpeed()) + "/s";
    }

    public void setConverter(AmountConverter converter) {
        if (converter == null) {
            this.setConverter(TRIVIAL_CONVERTER);
        } else {
            this.m_converter = converter;
        }
    }

    public void setRecentSpeedInterval(int recentSpeedInterval) {
        if (recentSpeedInterval <= 0) {
            recentSpeedInterval = 5000;
        }
        this.m_recentSpeedInterval = recentSpeedInterval;
    }

    public void setRecentSpeedResolution(int recentSpeedResolution) {
        if (recentSpeedResolution <= 0) {
            recentSpeedResolution = 1000;
        }
        this.m_recentSpeedResolution = recentSpeedResolution;
    }

    public void setReportInterval(int reportInterval) {
        this.m_reportInterval = reportInterval;
    }

    public boolean shouldReport() {
        Date current = new Date();
        if (this.m_lastReportTime == null || current.getTime() - this.m_lastReportTime.getTime() >= (long)this.m_reportInterval) {
            this.m_lastReportTime = current;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.report();
    }

    public static interface AmountConverter {
        public String convert(long var1);
    }

    static class FileSizeConverter
    implements AmountConverter {
        FileSizeConverter() {
        }

        public String convert(long amount) {
            if (amount < 1024L) {
                return String.format(Locale.US, "%dB", amount);
            }
            if (amount < 0x100000L) {
                return String.format(Locale.US, "%.2fkB", (double)amount / 1024.0);
            }
            return String.format(Locale.US, "%.2fMB", (double)amount / 1048576.0);
        }
    }

    static class TrivialConverter
    implements AmountConverter {
        TrivialConverter() {
        }

        public String convert(long amount) {
            return "" + amount;
        }
    }
}

