/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExpander {
    private final Map<String, ? extends Object> m_variableMap;

    private static final Map<String, String> getNamedPathMap(IActionContext ctx) throws CoreException {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, PathGroup[]> namedPathGroupArrays = ctx.getNamedPathGroupArrays();
        Set<String> keySet = namedPathGroupArrays.keySet();
        for (String pathGroupKey : keySet) {
            PathGroup[] pathGroups = namedPathGroupArrays.get(pathGroupKey);
            HashSet<String> pathSet = new HashSet<String>(5);
            PathGroup[] pathGroupArray = pathGroups;
            int n = pathGroups.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup pathGroup = pathGroupArray[n2];
                String base = pathGroup.getBase().toOSString();
                IPath[] paths = pathGroup.getPaths();
                if (paths.length == 0) {
                    pathSet.add(base);
                } else {
                    IPath[] iPathArray = paths;
                    int n3 = paths.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPath path = iPathArray[n4];
                        pathSet.add(String.valueOf(base) + path.toOSString());
                        ++n4;
                    }
                }
                ++n2;
            }
            StringBuffer buffer = new StringBuffer();
            for (String path : pathSet) {
                buffer.append(path).append(File.pathSeparatorChar);
            }
            int lastCharIndex = buffer.length() - 1;
            if (lastCharIndex <= 0 || buffer.charAt(lastCharIndex) != File.pathSeparatorChar) continue;
            map.put(pathGroupKey, buffer.substring(0, lastCharIndex));
        }
        return map;
    }

    private static final Map<String, ? extends Object> getVariables(IActionContext ctx) throws CoreException {
        HashMap<String, ? extends Object> map = new HashMap<String, Object>();
        map.putAll(PropertyExpander.getNamedPathMap(ctx));
        map.putAll(ctx.getProperties());
        return map;
    }

    public PropertyExpander(IActionContext ctx) throws CoreException {
        this.m_variableMap = PropertyExpander.getVariables(ctx);
    }

    public String expand(String string) {
        return ExpandingProperties.expand(this.m_variableMap, string, 1);
    }
}

