/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractBuildIntegrationActor
extends AbstractActor {
    protected String getNameForKind(IActionContext ctx) {
        return ctx.getAction().getName();
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 300);
        try {
            IProject project = WorkspaceInfo.getProject(ctx.getCSpec().getComponentIdentifier());
            if (project == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            project.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            project.build(WellknownActions.ECLIPSE.name2Kind(this.getNameForKind(ctx)), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)200));
            IMarker[] iMarkerArray = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker problem = iMarkerArray[n2];
                switch (problem.getAttribute("severity", 0)) {
                    case 2: {
                        throw new CoreException((IStatus)new Status(4, CorePlugin.getID(), 0, problem.getAttribute("message", ""), null));
                    }
                    case 1: {
                        Status status = new Status(2, CorePlugin.getID(), 0, problem.getAttribute("message", ""), null);
                        return status;
                    }
                }
                ++n2;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

