/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalContext
extends ModelCache
implements IGlobalContext {
    private final ArrayList<Integer> m_executedEclipseKinds = new ArrayList();
    private final ArrayList<IPath> m_scheduledRemovals = new ArrayList();
    private final Map<UUID, Object> m_invocationCache = new HashMap<UUID, Object>();
    private final HashSet<Action> m_actionsPerformed = new HashSet();
    private final Map<String, ? extends Object> m_globalProps = RMContext.getGlobalPropertyAdditions();
    private final boolean m_forcedExecution;
    private final boolean m_quietExecution;
    private boolean m_workspaceRefreshPending;
    private IStatus m_status;

    public GlobalContext(Map<String, ? extends Object> userProps, boolean forcedExecution, boolean quietExecution) {
        super(userProps);
        this.m_forcedExecution = forcedExecution;
        this.m_quietExecution = quietExecution;
    }

    @Override
    public Map<String, ? extends Object> getExecutionProperties(Attribute attribute) throws CoreException {
        Map actionProps = attribute instanceof IAction ? ((IAction)((Object)attribute)).getProperties() : Collections.emptyMap();
        int mapSize = this.m_globalProps.size() + actionProps.size() + 10;
        ExpandingProperties<Object> allProps = new ExpandingProperties<Object>(mapSize);
        allProps.putAll(this.m_globalProps, true);
        allProps.putAll(actionProps, true);
        allProps.putAll((Map<String, Object>)super.getProperties());
        attribute.addDynamicProperties(allProps);
        return allProps;
    }

    @Override
    public Map<UUID, Object> getInvocationCache() {
        return this.m_invocationCache;
    }

    @Override
    public synchronized Map<String, ? extends Object> getProperties() {
        Map<String, ? extends Object> userProperties = super.getProperties();
        ExpandingProperties<Object> allProps = new ExpandingProperties<Object>(userProperties.size() + this.m_globalProps.size());
        allProps.putAll(this.m_globalProps, true);
        allProps.putAll((Map<String, Object>)userProperties);
        return allProps;
    }

    @Override
    public IStatus getStatus() {
        return this.m_status;
    }

    @Override
    public void scheduleRemoval(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Only_absolute_paths_can_be_scheduled_for_removal_0, (Object)path.toOSString()));
        }
        int idx = this.m_scheduledRemovals.size();
        while (--idx >= 0) {
            IPath alreadyScheduled = this.m_scheduledRemovals.get(idx);
            if (alreadyScheduled.isPrefixOf(path)) {
                return;
            }
            if (!path.isPrefixOf(alreadyScheduled)) continue;
            this.m_scheduledRemovals.remove(idx);
        }
        this.m_scheduledRemovals.add(path);
    }

    public void setStatus(IStatus status) {
        this.m_status = status;
    }

    void addPerformedAction(Action action) {
        this.m_actionsPerformed.add(action);
    }

    boolean hasExecutedKind(int kind) {
        return this.m_executedEclipseKinds.contains(new Integer(kind));
    }

    boolean hasPerformedAction(IAction action) {
        return this.m_actionsPerformed.contains(action);
    }

    boolean isForcedExecution() {
        return this.m_forcedExecution;
    }

    boolean isQuietExecution() {
        return this.m_quietExecution;
    }

    boolean isWorkspaceRefreshPending() {
        return this.m_workspaceRefreshPending;
    }

    void kindWasExecuted(int kind) {
        Integer objKind = new Integer(kind);
        if (!this.m_executedEclipseKinds.contains(objKind)) {
            this.m_executedEclipseKinds.add(objKind);
        }
    }

    /*
     * Exception decompiling
     */
    synchronized void removeScheduled(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setWorkspaceRefreshPending(boolean flag) {
        this.m_workspaceRefreshPending = flag;
    }
}

