/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.util.Map;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.materializer.MaterializationStatistics;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationContext
extends RMContext {
    private final BillOfMaterials m_bom;
    private final MaterializationSpec m_materializationSpec;
    private final MaterializationStatistics m_statistics = new MaterializationStatistics();
    private boolean m_rebootNeeded = false;
    private boolean m_tagsInitialized = false;

    public MaterializationContext(BillOfMaterials bom, MaterializationSpec mspec) {
        super((Map<String, ? extends Object>)mspec.getProperties());
        this.m_bom = bom;
        this.m_materializationSpec = mspec;
    }

    public MaterializationContext(BillOfMaterials bom, MaterializationSpec mspec, RMContext context) {
        super(new UnmodifiableMapUnion<String, Object>(mspec.getProperties(), context), context);
        this.m_bom = bom;
        this.m_materializationSpec = mspec;
    }

    public IPath getArtifactLocation(Resolution resolution) throws CoreException {
        IPath installLocation = this.getInstallLocation(resolution);
        IPath leafArtifact = this.getLeafArtifact(resolution);
        installLocation = leafArtifact == null ? installLocation.addTrailingSeparator() : installLocation.append(leafArtifact);
        return installLocation;
    }

    public BillOfMaterials getBillOfMaterials() {
        return this.m_bom;
    }

    @Override
    public ComponentQuery getComponentQuery() {
        return this.m_bom.getQuery();
    }

    public IPath getInstallLocation(Resolution resolution) throws CoreException {
        IPath tmp;
        IPath ctypeRelative;
        IReaderType rd = this.m_materializationSpec.getMaterializer(resolution).getMaterializationReaderType(resolution);
        IPath relativeLocation = rd.getInstallLocation(resolution, this);
        IComponentType cType = resolution.getComponentType();
        if (cType != null && (ctypeRelative = cType.getRelativeLocation()) != null) {
            relativeLocation = relativeLocation == null ? ctypeRelative : relativeLocation.append(ctypeRelative);
        }
        if (relativeLocation != null && (tmp = this.expand(relativeLocation)).isAbsolute()) {
            return tmp;
        }
        IMaterializationNode node = this.m_materializationSpec.getMatchingNode(resolution);
        IPath nodeLocation = null;
        boolean useRootDefault = true;
        if (node != null) {
            IPath tmp2;
            nodeLocation = node.getInstallLocation();
            String materializerId = node.getMaterializerID();
            boolean bl = useRootDefault = materializerId == null || materializerId.equals(this.m_materializationSpec.getMaterializerID());
            if (nodeLocation != null && (tmp2 = this.expand(relativeLocation = relativeLocation != null ? nodeLocation.append(relativeLocation) : nodeLocation)).isAbsolute()) {
                return tmp2;
            }
        }
        IPath location = null;
        if (useRootDefault) {
            location = this.m_materializationSpec.getInstallLocation();
        }
        if (location == null) {
            location = this.m_materializationSpec.getMaterializer(resolution).getDefaultInstallRoot(this, resolution);
        }
        if (relativeLocation != null) {
            location = location.append(relativeLocation);
        }
        return this.expand(location);
    }

    public IPath getLeafArtifact(Resolution resolution) throws CoreException {
        MaterializationSpec mspec = this.getMaterializationSpec();
        IPath leaf = mspec.getLeafArtifact(resolution);
        boolean isExpand = mspec.isExpand(resolution);
        if (leaf != null) {
            if (isExpand) {
                leaf = leaf.addTrailingSeparator();
            }
            return leaf;
        }
        IReaderType rd = mspec.getMaterializer(resolution).getMaterializationReaderType(resolution);
        if (isExpand) {
            return null;
        }
        leaf = rd.getLeafArtifact(resolution, this);
        if (leaf == null) {
            ComponentIdentifier ci = resolution.getComponentIdentifier();
            StringBuilder nameBld = new StringBuilder(ci.getName());
            Version version = ci.getVersion();
            if (version != null) {
                nameBld.append('_');
                nameBld.append(version);
            }
            nameBld.append(".dat");
            leaf = Path.fromPortableString((String)nameBld.toString());
            if (leaf.segmentCount() > 1) {
                leaf = leaf.removeFirstSegments(leaf.segmentCount() - 1);
            }
        }
        return leaf;
    }

    public MaterializationSpec getMaterializationSpec() {
        return this.m_materializationSpec;
    }

    public MaterializationStatistics getMaterializationStatistics() {
        return this.m_statistics;
    }

    public int getMaxParallelJobs() {
        int maxParallelJobs = this.m_materializationSpec.getMaxParallelJobs();
        if (maxParallelJobs == -1) {
            maxParallelJobs = MaterializationJob.getMaxParallelJobs();
        }
        return maxParallelJobs;
    }

    @Override
    public Map<String, ? extends Object> getProperties(ComponentName cName) {
        UnmodifiableMapUnion<String, String> p = super.getProperties(cName);
        IMaterializationNode node = this.m_materializationSpec.getMatchingNode(cName);
        return node == null ? p : new UnmodifiableMapUnion<String, String>(node.getProperties(), p);
    }

    public Map<String, ? extends Object> getProperties(Resolution resolution) {
        UnmodifiableMapUnion<String, String> p = super.getProperties(resolution.getComponentIdentifier());
        IMaterializationNode node = this.m_materializationSpec.getMatchingNode(resolution);
        return node == null ? p : new UnmodifiableMapUnion<String, String>(node.getProperties(), p);
    }

    public String getSuffixedName(Resolution resolution, String remoteName) throws CoreException {
        MaterializationSpec mspec = this.getMaterializationSpec();
        ComponentIdentifier cName = resolution.getComponentIdentifier();
        if (!resolution.isUnpack() && !mspec.isUnpack(resolution)) {
            return null;
        }
        String name = mspec.getSuffix(resolution);
        if (name == null) {
            name = remoteName;
        }
        if (name == null) {
            IReaderType rd = resolution.getProvider().getReaderType();
            IPath leaf = rd.getLeafArtifact(resolution, this);
            if (leaf == null || leaf.segmentCount() == 0) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_determine_suffix_for_unpack_of_0, (Object)cName), (Object[])new Object[0]);
            }
            name = leaf.segment(0);
        }
        return name;
    }

    public IPath getWorkspaceLocation(Resolution resolution) throws CoreException {
        IPath tmp;
        IPath nodeLocation = null;
        ComponentIdentifier ci = resolution.getComponentIdentifier();
        IMaterializationNode node = this.m_materializationSpec.getMatchingNode(resolution);
        if (node != null && (nodeLocation = node.getWorkspaceLocation()) != null && (tmp = this.expand(nodeLocation = Path.fromOSString((String)ExpandingProperties.expand(this.getProperties(resolution), nodeLocation.toOSString(), 0)))).isAbsolute()) {
            return tmp;
        }
        IPath rootLocation = this.m_materializationSpec.getWorkspaceLocation();
        if (rootLocation == null) {
            if (nodeLocation != null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.WorkspaceLocation_0_in_node_matching_1_cannot_be_relative_unless, (Object)nodeLocation, (Object)ci), (Object[])new Object[0]);
            }
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return this.expand(nodeLocation == null ? rootLocation : rootLocation.append(nodeLocation));
    }

    public boolean isRebootNeeded() {
        return this.m_rebootNeeded;
    }

    public void setRebootNeeded(boolean flag) {
        this.m_rebootNeeded = flag;
    }

    @Override
    protected void initializeAllTagInfos() {
        if (!this.m_tagsInitialized) {
            this.addTagInfosFromBom(null);
            this.m_tagsInitialized = true;
        }
    }

    @Override
    protected void initializeTagInfo(IComponentRequest request) {
        this.addTagInfosFromBom(request);
    }

    private void addTagInfosFromBom(IComponentRequest request) {
        this.addTagInfosFromNode(this.m_bom.getQuery().getTagInfo(), this.m_bom, request);
    }

    private void addTagInfosFromNode(String tagInfo, BOMNode node, IComponentRequest request) {
        ComponentRequest nodeRequest = node.getRequest();
        if (this.hasTagInfo(nodeRequest)) {
            return;
        }
        Resolution res = node.getResolution();
        if (res == null || "eclipse.platform".equals(res.getProvider().getReaderTypeId())) {
            return;
        }
        this.addTagInfo(nodeRequest, tagInfo);
        if (node.getRequest().equals(request)) {
            return;
        }
        String childTagInfo = res.getCSpec().getTagInfo(tagInfo);
        for (BOMNode child : node.getChildren()) {
            this.addTagInfosFromNode(childTagInfo, child, request);
        }
    }

    private IPath expand(IPath path) {
        return Path.fromOSString((String)ExpandingProperties.expand(this, path.toOSString(), 0));
    }
}

