/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Materializer
extends AbstractMaterializer {
    private static final String CLASSIFIER_OSGI_BUNDLE = "osgi.bundle";
    private static final String CLASSIFIER_ORG_ECLIPSE_UPDATE_FEATURE = "org.eclipse.update.feature";
    private static final String PROP_ARTIFACT_FOLDER = "artifact.folder";

    static IArtifactRepository getArtifactRepository(IArtifactRepositoryManager manager, URI repoLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            return manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
        catch (ProvisionException e) {
            return manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
    }

    static IMetadataRepository getMetadataRepository(IMetadataRepositoryManager manager, URI repoLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            return manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
        catch (ProvisionException e) {
            return manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
        }
    }

    private static URI cleanURIFromImportType(URI repoLocation) {
        Map props = URLUtils.queryAsParameters((String)repoLocation.getQuery());
        if (props.remove("importType") != null) {
            try {
                repoLocation = new URI(repoLocation.getScheme(), repoLocation.getAuthority(), repoLocation.getPath(), URLUtils.encodeFromQueryPairs((Map)props), repoLocation.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return repoLocation;
    }

    @Override
    public boolean canWorkInParallel() {
        return false;
    }

    @Override
    public String getMaterializerRootDir() throws CoreException {
        File location = TargetPlatform.getInstance().getLocation();
        if (location == null) {
            throw BuckminsterException.fromMessage((String)Messages.Unable_to_determine_platform_install_location, (Object[])new Object[0]);
        }
        return location.getAbsolutePath();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<Materialization> materialize(List<Resolution> resolutions, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        block44: {
            resPerLocation = new HashMap<File, ArrayList<Resolution>>();
            mspec = context.getMaterializationSpec();
            installRoot = mspec.getInstallLocation();
            installRoot = installRoot == null ? Path.fromOSString((String)this.getMaterializerRootDir()) : Path.fromOSString((String)ExpandingProperties.expand(context, installRoot.toOSString(), 0));
            for (Resolution res : resolutions) {
                node = mspec.getMatchingNode(res);
                installLocation = null;
                props = context.getProperties(res);
                if (node != null && (installLocation = node.getInstallLocation()) != null && !(installLocation = Path.fromOSString((String)ExpandingProperties.expand(props, installLocation.toOSString(), 0))).isAbsolute()) {
                    installLocation = installRoot.append(installLocation);
                }
                if (installLocation == null) {
                    installLocation = installRoot;
                }
                if ((rss = (ArrayList<Resolution>)resPerLocation.get(locationKey = installLocation.toFile())) == null) {
                    rss = new ArrayList<Resolution>();
                    resPerLocation.put(locationKey, rss);
                }
                rss.add(res);
            }
            bucky = Buckminster.getDefault();
            subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(resPerLocation.size() * 1000));
            mdrsToRemove = null;
            arsToRemove = null;
            mdrManager = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
            arManager = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
            engine = (IEngine)bucky.getService(IEngine.class);
            registry = (IProfileRegistry)bucky.getService(IProfileRegistry.class);
            knownMDRs = new HashMap<URI, IMetadataRepository>();
            knownARs = new HashMap<URI, IArtifactRepository>();
            try {
                for (Map.Entry<K, V> entry : resPerLocation.entrySet()) {
                    destDir = (File)entry.getKey();
                    try {
                        destAR = arManager.createRepository(destDir.toURI(), "Runnable repository.", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
                    }
                    catch (ProvisionException e) {
                        destAR = arManager.loadRepository(destDir.toURI(), null);
                    }
                    ress = (List)entry.getValue();
                    ius = new ArrayList<IInstallableUnit>(ress.size());
                    for (Resolution res : ress) {
                        subSubMon = subMon.newChild(800 / ress.size());
                        subSubMon.setWorkRemaining(1000);
                        cid = res.getComponentIdentifier();
                        version = Version.create((String)cid.getVersion().toString());
                        repoURI = P2Materializer.cleanURIFromImportType(URI.create(res.getRepository()));
                        path = repoURI.getPath();
                        if (path.endsWith(".jar")) {
                            rType = res.getReaderTypeId();
                            if ("eclipse.import".equals(rType)) {
                                rType = "url";
                            }
                            if (!"url".equals(rType)) {
                                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.p2_materializer_cannot_process_readertype_0, (Object)rType), (Object[])new Object[0]);
                            }
                            ctype = CorePlugin.getDefault().getComponentType(cid.getComponentTypeID());
                            location = Path.fromOSString((String)destDir.getAbsolutePath());
                            ctypeRelative = ctype.getRelativeLocation();
                            if (ctypeRelative != null) {
                                location = location.append(ctypeRelative);
                            }
                            location.toFile().mkdirs();
                            leafName = String.valueOf(cid.getName()) + '_' + cid.getVersion();
                            if (res.isUnpack()) {
                                location = location.append(leafName);
                                location = location.addTrailingSeparator();
                            } else {
                                location = location.append(String.valueOf(leafName) + ".jar");
                            }
                            readerType = CorePlugin.getDefault().getReaderType(rType);
                            reader = readerType.getReader(res, context, (IProgressMonitor)subSubMon.newChild(10));
                            try {
                                reader.materialize(location, res, context, (IProgressMonitor)subSubMon.newChild(500));
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    throw BuckminsterException.wrap((Throwable)e);
                                }
                            }
                            if ("eclipse.feature".equals(cid.getComponentTypeID())) {
                                desc = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.update.feature", cid.getName(), version));
                                desc.addRepositoryProperties(Collections.singletonMap("artifact.folder", Boolean.toString(true)));
                            } else {
                                desc = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", cid.getName(), version));
                                if (res.isUnpack()) {
                                    desc.addRepositoryProperties(Collections.singletonMap("artifact.folder", Boolean.toString(true)));
                                }
                            }
                            destAR.addDescriptor((IArtifactDescriptor)desc);
                            continue;
                        }
                        mdr = (IMetadataRepository)knownMDRs.get(repoURI);
                        if (mdr == null) {
                            if (!mdrManager.contains(repoURI)) {
                                if (mdrsToRemove == null) {
                                    mdrsToRemove = new ArrayList<URI>();
                                }
                                mdrsToRemove.add(repoURI);
                            }
                            mdr = P2Materializer.getMetadataRepository(mdrManager, repoURI, (IProgressMonitor)subSubMon.newChild(500));
                            knownMDRs.put(repoURI, mdr);
                        }
                        range = new VersionRange(version, true, version, true);
                        collector = new Collector();
                        name = cid.getName();
                        isFeature = "eclipse.feature".equals(cid.getComponentTypeID());
                        if (isFeature) {
                            name = String.valueOf(name) + ".feature.jar";
                        }
                        mdr.query((Query)new InstallableUnitQuery(name, range), collector, (IProgressMonitor)subSubMon.newChild(250));
                        itor = collector.iterator();
                        if (!itor.hasNext()) {
                            throw new ProvisionException(NLS.bind((String)Messages.Unable_to_resolve_0_1_in_MDR_2, (Object[])new Object[]{cid.getName(), version, res.getRepository()}));
                        }
                        iu = (IInstallableUnit)itor.next();
                        ius.add(iu);
                        if (iu.getArtifacts().length > 0) {
                            ar = (IArtifactRepository)knownARs.get(repoURI);
                            if (ar != null) continue;
                            if (!arManager.contains(repoURI)) {
                                if (arsToRemove == null) {
                                    arsToRemove = new ArrayList<URI>();
                                }
                                arsToRemove.add(repoURI);
                            }
                            ar = P2Materializer.getArtifactRepository(arManager, repoURI, (IProgressMonitor)subSubMon.newChild(250));
                            knownARs.put(repoURI, ar);
                            continue;
                        }
                        subSubMon.worked(250);
                    }
                    operands = new InstallableUnitOperand[ius.size()];
                    i = 0;
                    for (IInstallableUnit iu : ius) {
                        operands[i++] = new InstallableUnitOperand(null, iu);
                    }
                    destDirStr = destDir.toString();
                    if (!registry.containsProfile(destDirStr)) {
                        properties = new HashMap<String, String>();
                        properties.put("org.eclipse.equinox.p2.cache.shared", Boolean.toString(false));
                        properties.put("org.eclipse.update.install.features", Boolean.toString(true));
                        properties.put("org.eclipse.equinox.p2.cache", destDirStr);
                        properties.put("org.eclipse.equinox.p2.installFolder", destDirStr);
                        registry.addProfile(destDirStr, properties);
                    }
                    profile = registry.getProfile(destDirStr);
                    try {
                        phaseSet = new PhaseSet(new Phase[]{new Collect(100)}){};
                        engine = (IEngine)bucky.getService(IEngine.class);
                        mdrURIs = knownMDRs.keySet();
                        arURIs = knownARs.keySet();
                        pctx = new ProvisioningContext(mdrURIs.toArray(new URI[mdrURIs.size()]));
                        pctx.setArtifactRepositories(arURIs.toArray(new URI[arURIs.size()]));
                        status = engine.perform(profile, phaseSet, (Operand[])operands, pctx, (IProgressMonitor)subMon.newChild(200));
                        if (status.getSeverity() != 4) continue;
                        throw BuckminsterException.wrap((IStatus)status);
                    }
                    finally {
                        registry.removeProfile(profile.getProfileId());
                    }
                }
                TargetPlatform.getInstance().locationsChanged(resPerLocation.keySet());
            }
            finally {
                if (mdrsToRemove == null) break block44;
                ** for (repoLocation : mdrsToRemove)
            }
lbl-1000:
            // 1 sources

            {
                mdrManager.removeRepository(repoLocation);
                continue;
            }
        }
        if (arsToRemove != null) {
            for (URI repoLocation : arsToRemove) {
                arManager.removeRepository(repoLocation);
            }
        }
        bucky.ungetService((Object)mdrManager);
        bucky.ungetService((Object)arManager);
        bucky.ungetService((Object)registry);
        bucky.ungetService((Object)engine);
        return Collections.emptyList();
    }
}

