/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.materializer.AbstractSiteMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.PlatformIgnoringFeature;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;

public class TargetPlatformMaterializer
extends AbstractSiteMaterializer {
    public static final String TARGET_PLATFORM_PATH = "targetPlatformPathForMaterialization";

    private static IPath getDefaultInstallRoot() throws CoreException {
        return Path.fromOSString((String)TargetPlatform.getInstance().getLocation().getAbsolutePath());
    }

    private static ISite getDefaultInstallSite() throws CoreException {
        IConfiguredSite installSite = null;
        IConfiguredSite[] configuredSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
        int idx = 0;
        while (idx < configuredSites.length) {
            IConfiguredSite configuredSite = configuredSites[idx];
            if (configuredSite.isProductSite() && configuredSite.isUpdatable()) {
                installSite = configuredSite;
                break;
            }
            ++idx;
        }
        if (installSite == null) {
            throw BuckminsterException.fromMessage((String)Messages.Could_not_find_a_site_to_install_to, (Object[])new Object[0]);
        }
        return installSite.getSite();
    }

    public IPath getDefaultInstallRoot(MaterializationContext context, Resolution resolution) throws CoreException {
        CorePlugin corePlugin = CorePlugin.getDefault();
        Preferences preferences = corePlugin.getPluginPreferences();
        String path = preferences.getString(TARGET_PLATFORM_PATH);
        if (!"".equals(path)) {
            return Path.fromOSString((String)path);
        }
        return TargetPlatformMaterializer.getDefaultInstallRoot();
    }

    public String getMaterializerRootDir() {
        return "downloads";
    }

    /*
     * Exception decompiling
     */
    protected ISite getDestinationSite(MaterializationContext context, IPath destination, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void installFeatures(MaterializationContext context, ISite destinationSite, ISite fromSite, ISiteFeatureReference[] featureRefs, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, featureRefs.length * 100);
        try {
            URL url = destinationSite.getURL();
            if ("file".equals(url.getProtocol())) {
                try {
                    File a = Path.fromPortableString((String)url.getPath()).toFile().getCanonicalFile();
                    File b = TargetPlatformMaterializer.getDefaultInstallRoot().toFile().getCanonicalFile();
                    if (a.equals(b)) {
                        context.setRebootNeeded(true);
                    }
                }
                catch (IOException a) {
                    // empty catch block
                }
            }
            ISiteFeatureReference[] iSiteFeatureReferenceArray = featureRefs;
            int n = featureRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteFeatureReference featureRef = iSiteFeatureReferenceArray[n2];
                IFeature feature = featureRef.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                IFeature platformIngoringFeature = this.convertFeature(feature, context);
                destinationSite.install(platformIngoringFeature, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private IFeature convertFeature(IFeature aFeature, MaterializationContext context) throws CoreException {
        PlatformIgnoringFeature piFeature = new PlatformIgnoringFeature(context);
        try {
            Class<?> clazz = aFeature.getClass();
            while (clazz != null) {
                Field[] fields = clazz.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.isEnumConstant()) {
                        field.setAccessible(true);
                        field.set((Object)piFeature, field.get(aFeature));
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return piFeature;
    }
}

