/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.TargetPlatform;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.metadata.AmbigousComponentException;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.core.metadata.MetadataSynchronizer;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.TimestampedKey;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceInfo {
    public static final QualifiedName PPKEY_COMPONENT_ID = new QualifiedName("org.eclipse.buckminster.core", "componentID");
    public static final QualifiedName PPKEY_GENERATED_CSPEC = new QualifiedName("org.eclipse.buckminster.core", "generatedCSpec");
    private static boolean s_hasBeenActivated;
    private static boolean s_hasBeenFullyInitialized;
    private static final HashMap<ComponentIdentifier, IPath> s_locationCache;
    private static final IResource[] s_noResources;
    private static final HashMap<ComponentIdentifier, Resolution> s_resolutionCache;

    static {
        s_locationCache = new HashMap();
        s_noResources = new IResource[0];
        s_resolutionCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedLocation(IComponentIdentifier cid) {
        HashMap<ComponentIdentifier, IPath> hashMap = s_locationCache;
        synchronized (hashMap) {
            s_locationCache.remove(cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearResolutionCache(IComponentIdentifier cid) {
        HashMap<ComponentIdentifier, Resolution> hashMap = s_resolutionCache;
        synchronized (hashMap) {
            s_resolutionCache.remove(cid);
        }
    }

    public static void forceRefreshOnAll(IProgressMonitor monitor) {
        MultiStatus status;
        block13: {
            CorePlugin plugin = CorePlugin.getDefault();
            if (plugin == null) {
                return;
            }
            status = new MultiStatus(plugin.toString(), 0, Messages.Problems_during_metadata_refresh, null);
            monitor.beginTask(Messages.Refreshing_meta_data, 1000);
            s_hasBeenActivated = true;
            try {
                try {
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    wsRoot.accept((IResourceVisitor)new MetadataSynchronizer.ResetVisitor());
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                    IProject[] projects = wsRoot.getProjects();
                    IResolution[] resolutions = (IResolution[])StorageManager.getDefault().getResolutions().getElements();
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                    int ticksPerRefresh = 900 / (resolutions.length > 0 ? resolutions.length : (projects.length > 0 ? projects.length : 1));
                    IResolution[] iResolutionArray = resolutions;
                    int n = resolutions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResolution res = iResolutionArray[n2];
                        if ("eclipse.platform".equals(res.getProvider().getReaderTypeId())) {
                            try {
                                WorkspaceInfo.resolveLocal(res.getRequest(), false);
                            }
                            catch (CoreException e) {
                                status.add(e.getStatus());
                            }
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)ticksPerRefresh);
                        }
                        ++n2;
                    }
                    iResolutionArray = projects;
                    n = projects.length;
                    n2 = 0;
                    while (n2 < n) {
                        IResolution project = iResolutionArray[n2];
                        try {
                            MetadataSynchronizer.refreshProject((IProject)project, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)ticksPerRefresh));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                    monitor.done();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        CorePlugin.logWarningsAndErrors((IStatus)status);
    }

    public static List<Resolution> getAllResolutions() throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        HashSet<Resolution> bld = new HashSet<Resolution>();
        Resolution[] resolutionArray = WorkspaceInfo.getActiveResolutions(sm);
        int n = resolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution cr = resolutionArray[n2];
            bld.add(cr);
            ++n2;
        }
        for (ComponentIdentifier ci : TargetPlatform.getInstance().getComponents()) {
            bld.add(WorkspaceInfo.getResolution(ci));
        }
        ArrayList<Resolution> sorted = new ArrayList<Resolution>(bld);
        Collections.sort(sorted, new Comparator<Resolution>(){

            @Override
            public int compare(Resolution o1, Resolution o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp == 0) {
                    Version v1 = o1.getVersion();
                    Version v2 = o2.getVersion();
                    cmp = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : v1.compareTo((Object)v2));
                }
                return cmp;
            }
        });
        return sorted;
    }

    public static ComponentIdentifier getComponentIdentifier(IResource resource) {
        WorkspaceInfo.checkFirstUse();
        String componentId = null;
        try {
            componentId = resource.getPersistentProperty(PPKEY_COMPONENT_ID);
            return componentId == null ? null : ComponentIdentifier.parse(componentId);
        }
        catch (CoreException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPath getComponentLocation(ComponentIdentifier componentIdentifier) throws CoreException {
        StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        HashMap<ComponentIdentifier, IPath> hashMap = s_locationCache;
        synchronized (hashMap) {
            IPath location = s_locationCache.get(componentIdentifier);
            if (location != null) {
                return location;
            }
            Materialization mat = WorkspaceInfo.getMaterialization(componentIdentifier);
            if (mat == null) {
                Resolution resolution = WorkspaceInfo.getResolution(componentIdentifier);
                location = resolution.getProvider().getReaderType().getFixedLocation(resolution);
                if (location == null) {
                    throw new MissingComponentException(componentIdentifier.toString());
                }
            } else {
                location = mat.getComponentLocation();
            }
            s_locationCache.put(componentIdentifier, location);
            return location;
        }
    }

    public static IPath getComponentLocation(CSpec cspec) throws CoreException {
        return WorkspaceInfo.getComponentLocation(cspec.getComponentIdentifier());
    }

    public static CSpec getCSpec(IResource resource) throws CoreException {
        WorkspaceInfo.checkFirstUse();
        ComponentIdentifier id = WorkspaceInfo.getComponentIdentifier(resource);
        return id == null ? null : WorkspaceInfo.getResolution(id).getCSpec();
    }

    public static List<Generator> getGenerators(String componentName) throws CoreException {
        List<Generator> generators = null;
        for (Resolution res : WorkspaceInfo.getAllResolutions()) {
            Generator generator = res.getCSpec().getGenerators().get(componentName);
            if (generator == null) continue;
            if (generators == null) {
                generators = new ArrayList<Generator>();
            }
            generators.add(generator);
        }
        if (generators == null) {
            generators = Collections.emptyList();
        }
        return generators;
    }

    public static Materialization getMaterialization(ComponentRequest request) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        Materialization bestFit = null;
        Materialization[] materializationArray = (Materialization[])sm.getMaterializations().getElements();
        int n = materializationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Materialization mat = materializationArray[n2];
            ComponentIdentifier ci = mat.getComponentIdentifier();
            if (request.designates(ci)) {
                if (!mat.getComponentLocation().toFile().exists()) {
                    mat.remove(StorageManager.getDefault());
                    mat = null;
                } else if (bestFit == null || ci.compareTo(bestFit.getComponentIdentifier()) > 0) {
                    bestFit = mat;
                }
            }
            ++n2;
        }
        return bestFit;
    }

    public static Materialization getMaterialization(IComponentIdentifier cid) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        Materialization[] materializationArray = (Materialization[])sm.getMaterializations().getElements();
        int n = materializationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Materialization mat = materializationArray[n2];
            if (cid.equals(mat.getComponentIdentifier())) {
                if (!mat.getComponentLocation().toFile().exists()) {
                    mat.remove(StorageManager.getDefault());
                    mat = null;
                }
                return mat;
            }
            ++n2;
        }
        return null;
    }

    public static Materialization getMaterialization(Resolution resolution) throws CoreException {
        return WorkspaceInfo.getMaterialization(resolution.getComponentIdentifier());
    }

    public static IProject getProject(IComponentIdentifier componentIdentifier) throws CoreException {
        return WorkspaceInfo.extractProject(WorkspaceInfo.getResources(componentIdentifier));
    }

    public static IProject getProject(Materialization materialization) throws CoreException {
        return WorkspaceInfo.extractProject(WorkspaceInfo.getResources(materialization));
    }

    public static Resolution getResolution(ComponentIdentifier wanted) throws CoreException {
        return WorkspaceInfo.getResolution(wanted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resolution getResolution(ComponentIdentifier wanted, boolean fromResolver) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        HashMap<ComponentIdentifier, Resolution> hashMap = s_resolutionCache;
        synchronized (hashMap) {
            Resolution candidate = s_resolutionCache.get(wanted);
            if (candidate == null) {
                Resolution[] resolutionArray = WorkspaceInfo.getActiveResolutions(sm);
                int n = resolutionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Resolution res = resolutionArray[n2];
                    ComponentIdentifier cid = res.getCSpec().getComponentIdentifier();
                    if (wanted.matches(cid)) {
                        if (wanted.getVersion() != null) {
                            candidate = res;
                            break;
                        }
                        if (candidate == null) {
                            candidate = res;
                        } else {
                            ComponentIdentifier candCid = candidate.getCSpec().getComponentIdentifier();
                            if (candCid.getComponentType() == null) {
                                if (cid.getComponentType() == null) {
                                    throw new AmbigousComponentException(wanted.toString());
                                }
                                candidate = res;
                            } else if (cid.getComponentType() != null) {
                                throw new AmbigousComponentException(wanted.toString());
                            }
                        }
                    }
                    ++n2;
                }
            }
            if (candidate != null) {
                s_resolutionCache.put(wanted, candidate);
                return candidate;
            }
        }
        if (!fromResolver) {
            Version v = wanted.getVersion();
            VersionRange vd = VersionHelper.exactRange(v);
            try {
                return WorkspaceInfo.resolveLocal(new ComponentRequest(wanted.getName(), wanted.getComponentTypeID(), vd), true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        throw new MissingComponentException(wanted.toString());
    }

    public static Resolution getResolution(ComponentRequest request, boolean fromResolver) throws CoreException {
        Resolution[] activeRess;
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        Resolution candidate = null;
        Resolution[] resolutionArray = activeRess = WorkspaceInfo.getActiveResolutions(sm);
        int n = activeRess.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution res = resolutionArray[n2];
            ComponentIdentifier id = res.getCSpec().getComponentIdentifier();
            if (request.designates(id) && (candidate == null || id.compareTo(candidate.getCSpec().getComponentIdentifier()) > 0)) {
                candidate = res;
            }
            ++n2;
        }
        if (candidate == null) {
            if (fromResolver) {
                throw new MissingComponentException(request.toString());
            }
            try {
                candidate = WorkspaceInfo.resolveLocal(request, true);
            }
            catch (MissingComponentException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new MissingComponentException(request.toString());
            }
        }
        return candidate;
    }

    public static IResource[] getResources(IComponentIdentifier componentIdentifier) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        ISaxableStorage<Materialization> mats = sm.getMaterializations();
        Materialization[] materializationArray = (Materialization[])mats.getElements();
        int n = materializationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Materialization mat = materializationArray[n2];
            if (componentIdentifier.equals(mat.getComponentIdentifier())) {
                return WorkspaceInfo.getResources(mat);
            }
            ++n2;
        }
        return s_noResources;
    }

    public static IResource[] getResources(IComponentRequest request) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        IResource[] allFound = s_noResources;
        ISaxableStorage<Materialization> mats = sm.getMaterializations();
        Materialization[] materializationArray = (Materialization[])mats.getElements();
        int n = materializationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            int top;
            Materialization mat = materializationArray[n2];
            if (request.designates(mat.getComponentIdentifier()) && (top = (resources = WorkspaceInfo.getResources(mat)).length) != 0) {
                if (allFound == s_noResources) {
                    allFound = resources;
                } else {
                    IResource[] concat = new IResource[allFound.length + top];
                    System.arraycopy(allFound, 0, concat, 0, allFound.length);
                    System.arraycopy(resources, 0, concat, allFound.length, top);
                    allFound = concat;
                }
            }
            ++n2;
        }
        return allFound;
    }

    public static IResource[] getResources(Materialization mat) throws CoreException {
        WorkspaceInfo.checkFirstUse();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath location = mat.getComponentLocation();
        URI locationURI = location.toFile().toURI();
        return location.hasTrailingSeparator() ? wsRoot.findContainersForLocationURI(locationURI) : wsRoot.findFilesForLocationURI(locationURI);
    }

    public static boolean isFullyInitialized() {
        return s_hasBeenFullyInitialized;
    }

    public static Resolution resolveLocal(IComponentRequest request, boolean useWorkspace) throws CoreException {
        WorkspaceInfo.checkFirstUse();
        ComponentQueryBuilder qbld = new ComponentQueryBuilder();
        qbld.setRootRequest(request);
        qbld.setPlatformAgnostic(true);
        AdvisorNodeBuilder nodeBld = qbld.addAdvisorNode();
        nodeBld.setNamePattern(Pattern.compile("^\\Q" + request.getName() + "\\E$"));
        nodeBld.setComponentTypeID(request.getComponentTypeID());
        nodeBld.setUseTargetPlatform(true);
        nodeBld.setUseWorkspace(useWorkspace);
        nodeBld.setUseMaterialization(false);
        nodeBld.setUseRemoteResolution(false);
        nodeBld = qbld.addAdvisorNode();
        nodeBld.setNamePattern(Pattern.compile(".*"));
        nodeBld.setUseTargetPlatform(true);
        nodeBld.setUseWorkspace(useWorkspace);
        nodeBld.setUseMaterialization(useWorkspace);
        nodeBld.setUseRemoteResolution(false);
        MainResolver main = new MainResolver(new ResolutionContext(qbld.createComponentQuery()));
        Resolution res = main.resolve((IProgressMonitor)new NullProgressMonitor()).getResolution();
        if (res == null) {
            throw new MissingComponentException(request.toString());
        }
        return res;
    }

    public static void runWorkspaceCatchUpJob() {
        MetadataSynchronizer.WorkspaceCatchUpJob catchUpJob = new MetadataSynchronizer.WorkspaceCatchUpJob();
        catchUpJob.schedule();
        try {
            catchUpJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        s_hasBeenFullyInitialized = true;
    }

    public static void setComponentIdentifier(IResource resource, IComponentIdentifier identifier) throws CoreException {
        resource.setPersistentProperty(PPKEY_COMPONENT_ID, identifier == null ? null : identifier.toString());
    }

    public static void validateMaterializations() throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        Materialization[] materializationArray = (Materialization[])sm.getMaterializations().getElements();
        int n = materializationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Materialization mt = materializationArray[n2];
            if (!mt.getComponentLocation().toFile().exists()) {
                mt.remove(sm);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFirstUse() {
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        synchronized (WorkspaceInfo.class) {
            if (s_hasBeenActivated) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            s_hasBeenActivated = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            WorkspaceInfo.runWorkspaceCatchUpJob();
            return;
        }
    }

    private static IProject extractProject(IResource[] resources) {
        int idx = resources.length;
        while (--idx >= 0) {
            IProject project;
            IResource resource = resources[idx];
            if (!(resource instanceof IProject) || !(project = (IProject)resource).isOpen()) continue;
            return project;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Resolution[] getActiveResolutions(StorageManager sm) throws CoreException {
        HashMap<ComponentName, TimestampedKey> resolutionKeys = new HashMap<ComponentName, TimestampedKey>();
        ArrayList<TimestampedKey> duplicates = null;
        ISaxableStorage<Resolution> ress = sm.getResolutions();
        ISaxableStorage<Materialization> mats = sm.getMaterializations();
        ISaxableStorage<Resolution> iSaxableStorage = ress;
        synchronized (iSaxableStorage) {
            Resolution[] resolutionArray = (Resolution[])ress.getElements();
            int n = resolutionArray.length;
            int n2 = 0;
            while (true) {
                block17: {
                    IPath prevLocation;
                    ComponentName cn;
                    TimestampedKey prevTsKey;
                    block18: {
                        Version prevVersion;
                        Version currVersion;
                        Resolution prevRes;
                        TimestampedKey tsKey;
                        IPath location;
                        ComponentIdentifier ci;
                        block21: {
                            Resolution res;
                            block20: {
                                block19: {
                                    if (n2 >= n) {
                                        break;
                                    }
                                    res = resolutionArray[n2];
                                    UUID resId = res.getId();
                                    ci = res.getComponentIdentifier();
                                    location = WorkspaceInfo.getResolutionLocation(mats, res);
                                    if (location == null || (prevTsKey = resolutionKeys.put(cn = ci.toPureComponentName(), tsKey = new TimestampedKey(resId, ress.getCreationTime(resId)))) == null || (prevLocation = WorkspaceInfo.getResolutionLocation(mats, prevRes = ress.getElement(prevTsKey.getKey()))) == null) break block17;
                                    if (!location.toFile().exists()) break block18;
                                    if (!location.equals((Object)prevLocation)) break block19;
                                    if (prevTsKey.getCreationTime() > tsKey.getCreationTime()) {
                                        resolutionKeys.put(cn, prevTsKey);
                                    }
                                    break block17;
                                }
                                if (!prevLocation.toFile().exists()) break block17;
                                if (!prevRes.getProvider().getReaderTypeId().equals("eclipse.platform")) break block20;
                                if (res.getProvider().getReaderTypeId().equals("eclipse.platform")) break block21;
                                break block17;
                            }
                            if (!res.getProvider().getReaderTypeId().equals("eclipse.platform")) break block21;
                            resolutionKeys.put(cn, prevTsKey);
                            break block17;
                        }
                        if (VersionHelper.equalsUnqualified(currVersion = ci.getVersion(), prevVersion = prevRes.getComponentIdentifier().getVersion())) {
                            if (prevTsKey.getCreationTime() > tsKey.getCreationTime()) {
                                resolutionKeys.put(cn, prevTsKey);
                            }
                            break block17;
                        } else {
                            if (duplicates == null) {
                                duplicates = new ArrayList<TimestampedKey>();
                            }
                            duplicates.add(prevTsKey);
                            CorePlugin.getLogger().debug("Found two entries for component %s. Version %s located at %s and version %s at %s", new Object[]{cn, currVersion, location, prevVersion, prevLocation});
                        }
                        break block17;
                    }
                    if (prevLocation.toFile().exists()) {
                        resolutionKeys.put(cn, prevTsKey);
                    } else {
                        resolutionKeys.remove(cn);
                    }
                }
                ++n2;
            }
        }
        int top = resolutionKeys.size();
        if (duplicates != null) {
            top += duplicates.size();
        }
        Resolution[] result = new Resolution[top];
        int idx = 0;
        for (TimestampedKey tsKey : resolutionKeys.values()) {
            result[idx++] = ress.getElement(tsKey.getKey());
        }
        if (duplicates != null) {
            for (TimestampedKey tsKey : duplicates) {
                result[idx++] = ress.getElement(tsKey.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IPath getResolutionLocation(ISaxableStorage<Materialization> mats, Resolution res) throws CoreException {
        IPath location;
        StorageManager.getDefault();
        WorkspaceInfo.checkFirstUse();
        ComponentIdentifier ci = res.getComponentIdentifier();
        HashMap<ComponentIdentifier, IPath> hashMap = s_locationCache;
        synchronized (hashMap) {
            location = s_locationCache.get(ci);
            if (location == null) {
                Materialization[] materializationArray = (Materialization[])mats.getElements();
                int n = materializationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Materialization mat = materializationArray[n2];
                    if (mat.getComponentIdentifier().equals(ci)) {
                        location = mat.getComponentLocation();
                        break;
                    }
                    ++n2;
                }
                if (location == null) {
                    location = res.getProvider().getReaderType().getFixedLocation(res);
                }
                if (location != null) {
                    s_locationCache.put(ci, location);
                }
            }
        }
        return location;
    }
}

