/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedNode
extends BOMNode {
    public static final String ATTR_RESOLUTION_ID = "resolutionId";
    public static final String CHILD_TAG = "child";
    public static final String TAG = "resolvedNode";
    private final List<BOMNode> m_children;
    private final Resolution m_resolution;

    public ResolvedNode(NodeQuery query, Resolution resolution) throws CoreException {
        this.m_resolution = resolution;
        CSpec cspec = resolution.getCSpec().prune(query.getContext(), query.getProperties(), query.isPrune(), resolution.getQualifiedDependency().getAttributeNames());
        List<QualifiedDependency> qDeps = cspec.getQualifiedDependencies(query.isPrune());
        int nDeps = qDeps.size();
        if (nDeps == 0) {
            this.m_children = Collections.emptyList();
        } else {
            ComponentQuery cquery = query.getComponentQuery();
            ArrayList<UnresolvedNode> children = new ArrayList<UnresolvedNode>(nDeps);
            for (QualifiedDependency qDep : qDeps) {
                ComponentRequest request = qDep.getRequest();
                IAdvisorNode override = cquery.getMatchingNode(request, query.getContext());
                if (override != null && (qDep = qDep.applyAdvice(override)) == null) continue;
                UnresolvedNode node = new UnresolvedNode(qDep);
                children.add(node);
            }
            this.m_children = Collections.unmodifiableList(children);
        }
    }

    public ResolvedNode(Resolution resolution, List<BOMNode> children) {
        this(resolution, children, false);
    }

    public ResolvedNode(Resolution resolution, List<BOMNode> children, boolean forBuild) {
        this.m_resolution = resolution;
        this.m_children = forBuild ? Collections.unmodifiableList(children) : Utils.createUnmodifiableList(children);
    }

    @Override
    public void addUnresolved(List<ComponentRequest> unresolved, Set<Resolution> skipThese) {
        if (skipThese.add(this.getResolution())) {
            for (BOMNode child : this.getChildren()) {
                child.addUnresolved(unresolved, skipThese);
            }
        }
    }

    @Override
    public List<Resolution> findAll(Set<Resolution> skipThese) throws CoreException {
        HashSet<Resolution> notThese = new HashSet<Resolution>();
        if (skipThese != null) {
            notThese.addAll(skipThese);
        }
        ArrayList<Resolution> all = new ArrayList<Resolution>();
        this.collectAll(notThese, all);
        return all;
    }

    @Override
    public synchronized List<BOMNode> getChildren() {
        return this.m_children;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return this.getResolution().getQualifiedDependency();
    }

    @Override
    public ComponentRequest getRequest() {
        return this.getResolution().getRequest();
    }

    @Override
    public synchronized Resolution getResolution() {
        return this.m_resolution;
    }

    @Override
    public String getViewName() throws CoreException {
        Resolution resolution = this.getResolution();
        StringBuilder bld = new StringBuilder();
        resolution.getRequest().appendViewName(bld);
        bld.append(':');
        resolution.getVersionMatch().toString(bld);
        return bld.toString();
    }

    @Override
    public boolean isChild(BOMNode node) {
        for (BOMNode child : this.m_children) {
            if (!child.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isReferencing(BOMNode node, boolean shallow) throws CoreException {
        if (this.equals(node)) {
            return true;
        }
        for (BOMNode child : this.m_children) {
            if (!child.equals(node)) continue;
            return true;
        }
        if (!shallow) {
            for (BOMNode child : this.m_children) {
                if (!child.isReferencing(node, shallow)) continue;
                return true;
            }
        }
        return false;
    }

    protected void addAttributes(AttributesImpl attrs) {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_ID, (String)this.m_resolution.getId().toString());
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        if (this.m_children.size() > 0) {
            String childName = Utils.makeQualifiedName((String)prefix, (String)CHILD_TAG);
            for (BOMNode child : this.m_children) {
                AttributesImpl attrs = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)attrs, (String)"refId", (String)child.getId().toString());
                receiver.startElement(namespace, CHILD_TAG, childName, attrs);
                receiver.endElement(namespace, CHILD_TAG, childName);
            }
        }
    }

    @Override
    protected boolean isFullyResolved(ComponentQuery query, HashSet<BOMNode> seen, Map<String, ? extends Object> properties) throws CoreException {
        if (seen.add(this)) {
            for (BOMNode child : this.getChildren()) {
                if (child.isFullyResolved(query, seen, properties)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery query, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
        Resolution resolution = this.getResolution();
        if (perused.add(resolution)) {
            for (BOMNode child : this.getChildren()) {
                child.addMaterializationCandidates(context, resolutions, query, mspec, perused);
            }
            ComponentIdentifier ci = resolution.getComponentIdentifier();
            if (resolution.isMaterializable() && !query.skipComponent(ci, context) && !mspec.isExcluded(resolution)) {
                resolutions.add(resolution);
            }
        }
    }

    @Override
    void collectAll(Set<Resolution> notThese, List<Resolution> all) throws CoreException {
        Resolution resolution = this.getResolution();
        if (notThese.add(resolution)) {
            for (BOMNode child : this.getChildren()) {
                child.collectAll(notThese, all);
            }
            all.add(this.getResolution());
        }
    }

    @Override
    BOMNode replaceNode(BOMNode topReplacer, BOMNode node, Map<BOMNode, BOMNode> visited) throws CoreException {
        BOMNode self = super.replaceNode(topReplacer, node, visited);
        if (self != this) {
            return self;
        }
        ArrayList<BOMNode> newChildren = null;
        List<BOMNode> oldChildren = this.getChildren();
        int numChildren = oldChildren.size();
        int idx = 0;
        while (idx < numChildren) {
            BOMNode newChild;
            BOMNode oldChild = oldChildren.get(idx);
            if (oldChild != (newChild = oldChild.replaceNode(topReplacer, node, visited))) {
                if (newChildren == null) {
                    newChildren = new ArrayList<BOMNode>(numChildren);
                    newChildren.addAll(oldChildren);
                }
                newChildren.set(idx, newChild);
            }
            ++idx;
        }
        if (newChildren == null) {
            return this;
        }
        self = new ResolvedNode(this.getResolution(), newChildren);
        visited.put(this, self);
        return self;
    }
}

