/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.IMaterializationSpec;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationSpecBuilder
extends MaterializationDirectiveBuilder
implements IMaterializationSpec {
    private final List<MaterializationNodeBuilder> m_nodes = new ArrayList<MaterializationNodeBuilder>();
    private String m_shortDesc;
    private String m_name;
    private String m_url;
    private URL m_contextURL;

    public MaterializationNodeBuilder addNodeBuilder() {
        MaterializationNodeBuilder node = new MaterializationNodeBuilder();
        this.m_nodes.add(node);
        return node;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_name = null;
        this.m_shortDesc = null;
        this.m_url = null;
        this.m_contextURL = null;
        this.m_nodes.clear();
    }

    public MaterializationSpec createMaterializationSpec() {
        return new MaterializationSpec(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter.isAssignableFrom(MaterializationSpec.class)) {
            return this.createMaterializationSpec();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public URL getContextURL() {
        return this.m_contextURL;
    }

    @Override
    public IMaterializationNode getMatchingNode(IComponentName cName) {
        return this.getMatchingNodeBuilder(cName);
    }

    @Override
    public IMaterializationNode getMatchingNode(Resolution res) {
        return this.getMatchingNodeBuilder(res);
    }

    public MaterializationNodeBuilder getMatchingNodeBuilder(IComponentName cName) {
        String name = cName.getName();
        for (MaterializationNodeBuilder aNode : this.m_nodes) {
            String matchingCType;
            Pattern pattern = aNode.getNamePattern();
            if (pattern == null || !pattern.matcher(name).find() || (matchingCType = aNode.getComponentTypeID()) != null && !matchingCType.equals(cName.getComponentTypeID())) continue;
            return aNode;
        }
        return null;
    }

    public MaterializationNodeBuilder getMatchingNodeBuilder(Resolution res) {
        Map<String, ? extends Object> props = null;
        ComponentIdentifier ci = res.getComponentIdentifier();
        for (MaterializationNodeBuilder aNode : this.m_nodes) {
            String matchingCType;
            Pattern pattern = aNode.getNamePattern();
            if (pattern != null && !pattern.matcher(ci.getName()).find() || (matchingCType = aNode.getComponentTypeID()) != null && !matchingCType.equals(ci.getComponentTypeID())) continue;
            Filter filter = aNode.getFilter();
            if (filter != null) {
                if (props == null) {
                    props = res.getProperties();
                }
                if (!filter.match(props)) continue;
            }
            return aNode;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public List<MaterializationNodeBuilder> getNodeBuilders() {
        return this.m_nodes;
    }

    @Override
    public List<? extends IMaterializationNode> getNodes() {
        return this.getNodeBuilders();
    }

    @Override
    public URL getResolvedURL() {
        return URLUtils.resolveURL((URL)this.m_contextURL, (String)this.m_url);
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    @Override
    public String getURL() {
        return this.m_url;
    }

    public void initFrom(IMaterializationSpec mspec) {
        super.initFrom(mspec);
        this.m_name = mspec.getName();
        this.m_shortDesc = mspec.getShortDesc();
        this.m_url = mspec.getURL();
        this.m_contextURL = mspec.getContextURL();
        for (IMaterializationNode iMaterializationNode : mspec.getNodes()) {
            MaterializationNodeBuilder nodeBuilder = new MaterializationNodeBuilder();
            nodeBuilder.initFrom(iMaterializationNode);
            this.m_nodes.add(nodeBuilder);
        }
    }

    public void setContextURL(URL contextURL) {
        this.m_contextURL = contextURL;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setShortDesc(String shortDesc) {
        this.m_shortDesc = shortDesc;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        MaterializationSpec mspec = new MaterializationSpec(this);
        mspec.toSax(receiver);
    }
}

