/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.model;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationDirective;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MaterializationNode
extends MaterializationDirective
implements IMaterializationNode {
    public static final String TAG = "mspecNode";
    public static final String ATTR_NAME_PATTERN = "namePattern";
    public static final String ATTR_FILTER = "filter";
    public static final String ATTR_LEAF_ARTIFACT = "leafArtifact";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_EXCLUDE = "exclude";
    public static final String ATTR_RESOURCE_PATH = "resourcePath";
    public static final String ATTR_BINDING_NAME_PATTERN = "bindingNamePattern";
    public static final String ATTR_BINDING_NAME_REPLACEMENT = "bindingNameReplacement";
    public static final String ELEM_UNPACK = "unpack";
    public static final String ATTR_SUFFIX = "suffix";
    public static final String ATTR_EXPAND = "expand";
    private final Pattern m_namePattern;
    private final Filter m_filter;
    private final IPath m_leafArtifact;
    private final String m_componentTypeID;
    private final boolean m_exclude;
    private final IPath m_resourcePath;
    private final Pattern m_bindingNamePattern;
    private final String m_bindingNameReplacement;
    private final String m_suffix;
    private final boolean m_unpack;
    private final boolean m_expand;

    public MaterializationNode(MaterializationNodeBuilder builder) {
        super(builder);
        this.m_namePattern = builder.getNamePattern();
        this.m_filter = builder.getFilter();
        this.m_leafArtifact = builder.getLeafArtifact();
        this.m_componentTypeID = builder.getComponentTypeID();
        this.m_exclude = builder.isExclude();
        this.m_resourcePath = builder.getResourcePath();
        this.m_bindingNamePattern = builder.getBindingNamePattern();
        this.m_bindingNameReplacement = builder.getBindingNameReplacement();
        this.m_suffix = builder.getSuffix();
        this.m_unpack = builder.isUnpack();
        this.m_expand = builder.isExpand();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(MaterializationNodeBuilder.class)) {
            MaterializationNodeBuilder bld = new MaterializationNodeBuilder();
            bld.initFrom(this);
            return bld;
        }
        return super.getAdapter(adapter);
    }

    public Pattern getBindingNamePattern() {
        return this.m_bindingNamePattern;
    }

    public String getBindingNameReplacement() {
        return this.m_bindingNameReplacement;
    }

    public String getComponentTypeID() {
        return this.m_componentTypeID;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public IPath getLeafArtifact() {
        return this.m_leafArtifact;
    }

    public Pattern getNamePattern() {
        return this.m_namePattern;
    }

    public IPath getResourcePath() {
        return this.m_resourcePath;
    }

    public String getSuffix() {
        return this.m_suffix;
    }

    public boolean isExclude() {
        return this.m_exclude;
    }

    public boolean isExpand() {
        return this.m_expand;
    }

    public boolean isUnpack() {
        return this.m_unpack;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        if (this.m_namePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME_PATTERN, (String)this.m_namePattern.toString());
        }
        if (this.m_filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.m_filter.toString());
        }
        if (this.m_componentTypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.m_componentTypeID);
        }
        if (this.m_leafArtifact != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LEAF_ARTIFACT, (String)this.m_leafArtifact.toPortableString());
        }
        if (this.m_resourcePath != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOURCE_PATH, (String)this.m_resourcePath.toPortableString());
        }
        if (this.m_exclude) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXCLUDE, (String)"true");
        }
        if (this.m_bindingNamePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BINDING_NAME_PATTERN, (String)this.m_bindingNamePattern.toString());
        }
        if (this.m_bindingNameReplacement != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BINDING_NAME_REPLACEMENT, (String)this.m_bindingNameReplacement);
        }
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        super.emitElements(receiver, namespace, prefix);
        if (this.m_unpack) {
            AttributesImpl attrs = new AttributesImpl();
            if (!this.m_expand) {
                Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXPAND, (String)"false");
            }
            if (this.m_suffix != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SUFFIX, (String)this.m_suffix);
            }
            String qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_UNPACK);
            receiver.startElement(namespace, ELEM_UNPACK, qName, attrs);
            receiver.endElement(namespace, ELEM_UNPACK, qName);
        }
    }
}

