/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.IMaterializationSpec;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationDirective;
import org.eclipse.buckminster.core.mspec.model.MaterializationNode;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationSpec
extends MaterializationDirective
implements ISaxable,
IMaterializationSpec {
    public static final String TAG = "mspec";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SHORT_DESC = "shortDesc";
    public static final String ATTR_URL = "url";
    private final String m_name;
    private final String m_shortDesc;
    private final String m_url;
    private final List<MaterializationNode> m_nodes;
    private final URL m_contextURL;
    private BillOfMaterials m_currentBom;

    public static MaterializationSpec fromStream(String systemId, InputStream stream) throws CoreException {
        try {
            IParserFactory pf = CorePlugin.getDefault().getParserFactory();
            IParser<MaterializationSpec> parser = pf.getMaterializationSpecParser(false);
            return parser.parse(systemId, stream);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static MaterializationSpec fromURL(URL url) throws CoreException {
        InputStream stream = null;
        try {
            stream = DownloadManager.read((URL)url, null);
            MaterializationSpec materializationSpec = MaterializationSpec.fromStream(url.toString(), stream);
            return materializationSpec;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)stream);
        }
    }

    public MaterializationSpec(MaterializationSpecBuilder builder) {
        super(builder);
        this.m_name = builder.getName();
        this.m_shortDesc = builder.getShortDesc();
        this.m_url = builder.getURL();
        this.m_contextURL = builder.getContextURL();
        ArrayList<MaterializationNode> nodes = new ArrayList<MaterializationNode>();
        for (MaterializationNodeBuilder nodeBuilder : builder.getNodeBuilders()) {
            nodes.add(nodeBuilder.createMaterializationNode());
        }
        this.m_nodes = Utils.createUnmodifiableList(nodes);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(MaterializationSpecBuilder.class)) {
            MaterializationSpecBuilder bld = new MaterializationSpecBuilder();
            bld.initFrom(this);
            return bld;
        }
        return super.getAdapter(adapter);
    }

    @Deprecated
    public ConflictResolution getConflictResolution(IComponentName cName) {
        return this.getConflictResolution(this.getMatchingNode(cName));
    }

    public ConflictResolution getConflictResolution(Resolution res) {
        return this.getConflictResolution(this.getMatchingNode(res));
    }

    @Override
    public URL getContextURL() {
        return this.m_contextURL;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Deprecated
    public IPath getLeafArtifact(IComponentName cname) {
        IMaterializationNode node = this.getMatchingNode(cname);
        return node == null ? null : node.getLeafArtifact();
    }

    public IPath getLeafArtifact(Resolution resolution) {
        IMaterializationNode node = this.getMatchingNode(resolution);
        return node == null ? null : node.getLeafArtifact();
    }

    @Override
    public IMaterializationNode getMatchingNode(IComponentName cName) {
        if (this.m_currentBom != null && cName instanceof IComponentIdentifier) {
            try {
                return this.getMatchingNode(this.m_currentBom.getResolvedNode((IComponentIdentifier)cName).getResolution());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.getMatchingNode(cName, ((ComponentName)cName).getProperties());
    }

    @Override
    public IMaterializationNode getMatchingNode(Resolution res) {
        return this.getMatchingNode(res.getComponentIdentifier(), res.getProperties());
    }

    public IMaterializer getMaterializer(Resolution resolution) throws CoreException {
        return CorePlugin.getDefault().getMaterializer(this.getMaterializerID(resolution));
    }

    public String getMaterializerID(Resolution resolution) throws CoreException {
        String materializer;
        IMaterializationNode node = this.getMatchingNode(resolution);
        String string = materializer = node == null ? null : node.getMaterializerID();
        if (materializer == null && (materializer = this.getMaterializerID()) == null) {
            materializer = resolution.getProvider().getReaderType().getRecommendedMaterializer();
        }
        return materializer;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public List<? extends IMaterializationNode> getNodes() {
        return this.m_nodes;
    }

    @Deprecated
    public String getProjectName(ComponentName cName) throws CoreException {
        return this.getProjectName(cName, this.getMatchingNode(cName));
    }

    public String getProjectName(Resolution res) throws CoreException {
        return this.getProjectName(res.getComponentIdentifier(), this.getMatchingNode(res));
    }

    @Override
    public URL getResolvedURL() {
        return URLUtils.resolveURL((URL)this.m_contextURL, (String)ExpandingProperties.expand(RMContext.getGlobalPropertyAdditions(), this.m_url, 0));
    }

    @Deprecated
    public IPath getResourcePath(IComponentName cName) {
        IMaterializationNode node = this.getMatchingNode(cName);
        return node == null ? null : node.getResourcePath();
    }

    public IPath getResourcePath(Resolution res) {
        IMaterializationNode node = this.getMatchingNode(res);
        return node == null ? null : node.getResourcePath();
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    @Deprecated
    public String getSuffix(IComponentName cName) {
        IMaterializationNode node = this.getMatchingNode(cName);
        return node == null ? null : node.getSuffix();
    }

    public String getSuffix(Resolution res) {
        IMaterializationNode node = this.getMatchingNode(res);
        return node == null ? null : node.getSuffix();
    }

    @Override
    public String getURL() {
        return this.m_url;
    }

    public boolean isExcluded(IComponentName cname) {
        IMaterializationNode node = this.getMatchingNode(cname);
        return node != null && node.isExclude();
    }

    public boolean isExcluded(Resolution res) {
        IMaterializationNode node = this.getMatchingNode(res);
        return node != null && node.isExclude();
    }

    @Deprecated
    public boolean isExpand(IComponentName cName) {
        IMaterializationNode node = this.getMatchingNode(cName);
        return node != null && node.isUnpack() && node.isExpand();
    }

    public boolean isExpand(Resolution res) {
        IMaterializationNode node = this.getMatchingNode(res);
        return node != null && node.isUnpack() && node.isExpand();
    }

    @Deprecated
    public boolean isUnpack(IComponentName cName) {
        IMaterializationNode node = this.getMatchingNode(cName);
        return node != null && node.isUnpack();
    }

    public boolean isUnpack(Resolution res) {
        IMaterializationNode node = this.getMatchingNode(res);
        return node != null && node.isUnpack();
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        this.toSax(handler, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.getDefaultTag());
        handler.endDocument();
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME, (String)this.m_name);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_URL, (String)this.m_url);
        if (this.m_shortDesc != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SHORT_DESC, (String)this.m_shortDesc);
        }
    }

    @Override
    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        super.emitElements(receiver, namespace, prefix);
        for (MaterializationNode node : this.m_nodes) {
            node.toSax(receiver, namespace, prefix, node.getDefaultTag());
        }
    }

    private ConflictResolution getConflictResolution(IMaterializationNode node) {
        ConflictResolution cr = null;
        if (node != null) {
            cr = node.getConflictResolution();
        }
        if (cr == null && (cr = this.getConflictResolution()) == null) {
            cr = ConflictResolution.getDefault();
        }
        return cr;
    }

    private IMaterializationNode getMatchingNode(IComponentName cName, Map<String, ? extends Object> props) {
        for (MaterializationNode aNode : this.m_nodes) {
            Filter filter;
            String matchingCType;
            Pattern pattern = aNode.getNamePattern();
            if (pattern != null && !pattern.matcher(cName.getName()).find() || (matchingCType = aNode.getComponentTypeID()) != null && !matchingCType.equals(cName.getComponentTypeID()) || (filter = aNode.getFilter()) != null && !filter.match(props)) continue;
            return aNode;
        }
        return null;
    }

    private String getProjectName(ComponentName cName, IMaterializationNode node) throws CoreException {
        String repl;
        if (node == null) {
            return cName.getProjectName();
        }
        Pattern bindingNamePattern = node.getBindingNamePattern();
        String bindingNameReplacement = node.getBindingNameReplacement();
        if (bindingNamePattern == null || bindingNameReplacement == null) {
            return cName.getProjectName();
        }
        Matcher matcher = bindingNamePattern.matcher(cName.getName());
        if (matcher.matches() && (repl = matcher.replaceAll(bindingNameReplacement).trim()).length() > 0) {
            return repl;
        }
        return cName.getProjectName();
    }
}

