/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.parser;

import java.util.Map;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaterializationDirectiveHandler
extends PropertyManagerHandler {
    private DocumentationHandler m_documentationHandler;
    private final MaterializationDirectiveBuilder m_builder;

    public MaterializationDirectiveHandler(AbstractHandler parent, String tag, MaterializationDirectiveBuilder builder) {
        super(parent, tag);
        this.m_builder = builder;
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_documentationHandler) {
            this.m_builder.setDocumentation(this.m_documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        DocumentationHandler ch;
        if ("documentation".equals(localName)) {
            if (this.m_documentationHandler == null) {
                this.m_documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.m_documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    MaterializationDirectiveBuilder getBuilder() {
        return this.m_builder;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_builder.getProperties();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_builder.clear();
        String tmp = MaterializationDirectiveHandler.getOptionalStringValue((Attributes)attrs, (String)"installLocation");
        if (tmp != null) {
            this.m_builder.setInstallLocation(Path.fromPortableString((String)tmp));
        }
        if ((tmp = MaterializationDirectiveHandler.getOptionalStringValue((Attributes)attrs, (String)"workspaceLocation")) != null) {
            this.m_builder.setWorkspaceLocation(Path.fromPortableString((String)tmp));
        }
        this.m_builder.setMaterializerID(MaterializationDirectiveHandler.getOptionalStringValue((Attributes)attrs, (String)"materializer"));
        this.m_builder.setMaxParallelJobs(MaterializationDirectiveHandler.getOptionalIntValue((Attributes)attrs, (String)"maxParallelJobs", (int)-1));
        tmp = MaterializationDirectiveHandler.getOptionalStringValue((Attributes)attrs, (String)"conflictResolution");
        if (tmp != null) {
            try {
                this.m_builder.setConflictResolution(ConflictResolution.valueOf(tmp));
            }
            catch (IllegalArgumentException e) {
                throw new SAXParseException(NLS.bind((String)Messages.Invalid_value_for_attribute_0, (Object)"conflictResolution"), this.getDocumentLocator());
            }
        }
    }
}

