/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.ParserFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.TopHandler;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser<T>
extends TopHandler
implements ErrorHandler,
IParser<T> {
    private static Pattern s_saxParseCleaner = Pattern.compile("^cvc-[^:]+:(.*)$");
    private static IFile[] s_noFiles = new IFile[0];
    private final boolean m_validating;
    private final List<String> m_namespaceLocations;
    private final List<ParserFactory.ParserExtension> m_parserExtensions;
    private HashSet<String> m_printedWarnings;

    public static IFile[] clearMarkers(String systemId) {
        IFile[] files = AbstractParser.getFilesForSystemId(systemId);
        try {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return files;
    }

    public static XMLReader createXMLReader(boolean validating, boolean withNamespace) throws CoreException {
        try {
            return Utils.createXMLReader((boolean)validating, (boolean)withNamespace);
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static void setMarkers(IFile[] files, SAXParseException e) {
        try {
            String msg = e.getMessage();
            Matcher match = s_saxParseCleaner.matcher(msg);
            if (match.matches()) {
                msg = match.group(1);
            }
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("priority", 2);
                marker.setAttribute("severity", 2);
                marker.setAttribute("lineNumber", e.getLineNumber());
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static IFile[] getFilesForSystemId(String systemId) {
        if (systemId == null || systemId.contains(".metadata")) {
            return s_noFiles;
        }
        try {
            URL url = new URL(systemId);
            File file = FileUtils.getFile(url);
            if (file == null) {
                return s_noFiles;
            }
            systemId = file.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(systemId));
    }

    protected AbstractParser(List<ParserFactory.ParserExtension> parserExtensions, String[] namespaces, String[] schemaLocations, boolean validating) throws CoreException {
        super(AbstractParser.createXMLReader(validating, true));
        this.m_validating = validating;
        int top = namespaces.length;
        if (top != schemaLocations.length) {
            throw new IllegalArgumentException(Messages.The_namespace_and_schemaLocation_arrays_must_be_equal_in_length);
        }
        this.m_namespaceLocations = new ArrayList<String>();
        int idx = 0;
        while (idx < top) {
            String namespace = namespaces[idx];
            String schemaFile = schemaLocations[idx];
            URL schemaURL = this.getClass().getResource(schemaFile);
            if (schemaURL == null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_find_XMLSchema_for_namespace_0, (Object)namespace), (Object[])new Object[0]);
            }
            this.addNamespaceLocation(namespace, schemaURL);
            ++idx;
        }
        if (parserExtensions != null) {
            for (ParserFactory.ParserExtension pe : parserExtensions) {
                this.addNamespaceLocation(pe.getNamespace(), pe.getResource());
            }
        }
        this.m_parserExtensions = parserExtensions;
        this.setNamespaceAware(true);
        this.setErrorHandler(this);
    }

    public <H extends ChildHandler> H createContentHandler(AbstractHandler parent, Class<H> handlerClass, String namespace, String xsiType) throws SAXException {
        try {
            if (xsiType != null && this.m_parserExtensions != null) {
                String ns;
                int colonIndex = xsiType.indexOf(58);
                if (colonIndex > 0) {
                    String prefix = xsiType.substring(0, colonIndex);
                    ns = this.getPrefixMapping(prefix);
                    if (ns == null) {
                        throw new SAXParseException(NLS.bind((String)Messages.Unknown_namespace_prefix_0, (Object)prefix), this.getDocumentLocator());
                    }
                    xsiType = xsiType.substring(colonIndex + 1);
                } else {
                    ns = namespace;
                }
                for (ParserFactory.ParserExtension pe : this.m_parserExtensions) {
                    if (!pe.getNamespace().equals(ns)) continue;
                    return (H)((ChildHandler)handlerClass.cast(pe.getHandler(parent, xsiType)));
                }
            }
            try {
                Constructor<H> ctor = handlerClass.getConstructor(AbstractHandler.class);
                return (H)((ChildHandler)ctor.newInstance(parent));
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new SAXParseException(NLS.bind((String)Messages.Unable_to_create_extension_handler_0_1, (Object)namespace, (Object)xsiType), this.getDocumentLocator(), e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warningOnce(String warning) {
        if (this.m_printedWarnings == null) {
            this.m_printedWarnings = new HashSet();
        } else if (this.m_printedWarnings.contains(warning)) {
            return;
        }
        this.m_printedWarnings.add(warning);
        CorePlugin.getLogger().warning(warning, new Object[0]);
    }

    protected void addNamespaceLocation(String namespace, URL location) {
        this.m_namespaceLocations.add(String.valueOf(namespace) + ' ' + location.toString());
    }

    protected void init() throws SAXException {
        XMLReader reader = this.getXMLReader();
        if (this.m_validating) {
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        int len = 0;
        int top = this.m_namespaceLocations.size();
        int idx = 0;
        while (idx < top) {
            len += this.m_namespaceLocations.get(idx).length();
            ++len;
            ++idx;
        }
        StringBuilder bld = new StringBuilder(len);
        int idx2 = 0;
        while (idx2 < top) {
            if (idx2 > 0) {
                bld.append(' ');
            }
            bld.append(this.m_namespaceLocations.get(idx2));
            ++idx2;
        }
        reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", bld.toString());
    }

    protected void parseInput(String systemId, InputStream input) throws CoreException {
        IFile[] files = AbstractParser.clearMarkers(systemId);
        try {
            try {
                this.init();
                if (!(input instanceof BufferedInputStream) && !(input instanceof ByteArrayInputStream)) {
                    input = new BufferedInputStream(input);
                }
                InputSource source = new InputSource(input);
                if (systemId != null) {
                    source.setSystemId(systemId);
                }
                this.getXMLReader().parse(source);
            }
            catch (SAXParseException e) {
                AbstractParser.setMarkers(files, e);
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            this.getXMLReader().setContentHandler((ContentHandler)((Object)this));
        }
    }
}

