/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.io.IOException;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public abstract class AbstractReader
implements IComponentReader {
    private final ProviderMatch m_providerMatch;
    private final IReaderType m_readerType;

    protected AbstractReader(IReaderType readerType, ProviderMatch providerMatch) {
        this.m_providerMatch = providerMatch;
        this.m_readerType = readerType;
    }

    public boolean canMaterialize() {
        return true;
    }

    public void close() {
    }

    protected void copyOverlay(IPath destination, IProgressMonitor monitor) throws CoreException {
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile(String.valueOf(this.getReaderType().getId()) + '-', ".tmp");
    }

    public IComponentType getComponentType() {
        return this.m_providerMatch.getComponentType();
    }

    public IConnectContext getConnectContext() {
        return this.m_providerMatch.getConnectContext();
    }

    public NodeQuery getNodeQuery() {
        return this.m_providerMatch.getNodeQuery();
    }

    public ProviderMatch getProviderMatch() {
        return this.m_providerMatch;
    }

    public IReaderType getReaderType() {
        return this.m_readerType;
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        return this.getProviderMatch().getVersionConverter();
    }

    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.getNodeQuery().logDecision(request, decisionType, args);
    }

    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.getNodeQuery().logDecision(decisionType, args);
    }
}

