/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.SiteFeatureFinder;
import org.eclipse.buckminster.core.reader.SiteFeatureReader;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class SiteFeatureReaderType
extends CatalogReaderType {
    public static void checkComponentType(Provider provider) throws CoreException {
        String[] ctypeIDs = provider.getComponentTypeIDs();
        if (ctypeIDs.length != 1 || !"site.feature".equals(ctypeIDs[0])) {
            throw BuckminsterException.fromMessage((String)Messages.Site_reader_can_only_be_used_with_site_feature, (Object[])new Object[0]);
        }
    }

    public static synchronized ISite getSite(String siteURLStr, IProgressMonitor monitor) throws CoreException {
        try {
            URL siteURL = URLUtils.normalizeToURL((String)siteURLStr);
            if (siteURL.getPath().endsWith("/")) {
                siteURL = URLUtils.appendPath((URL)siteURL, (IPath)Path.fromPortableString((String)"site.xml"));
            }
            return SiteManager.getSite((URL)siteURL, (IProgressMonitor)monitor);
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (CoreException e) {
            CoreException ew = new CoreException(BuckminsterException.createStatus((Throwable)e, (String)NLS.bind((String)Messages.Unable_to_obtain_site_from_0, (Object)siteURLStr), (Object[])new Object[0]));
            ew.initCause((Throwable)e);
            throw ew;
        }
    }

    public static IFeature getSiteFeature(String siteURLStr, ComponentIdentifier ci, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 200);
        try {
            ISite site = SiteFeatureReaderType.getSite(siteURLStr, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            ISiteFeatureReference ref = SiteFeatureReaderType.getSiteFeatureReference(site, ci);
            IFeature iFeature = ref == null ? null : ref.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            return iFeature;
        }
        finally {
            monitor.done();
        }
    }

    public static ISiteFeatureReference getSiteFeatureReference(ISite site, ComponentIdentifier ci) throws CoreException {
        ISiteFeatureReference[] iSiteFeatureReferenceArray = site.getRawFeatureReferences();
        int n = iSiteFeatureReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeatureReference ref = iSiteFeatureReferenceArray[n2];
            if (SiteFeatureReaderType.isEqual(ci, ref.getVersionedIdentifier())) {
                return ref;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isEqual(ComponentIdentifier ci, VersionedIdentifier vi) {
        if (!ci.getName().equals(vi.getIdentifier())) {
            return false;
        }
        Version version = ci.getVersion();
        PluginVersionIdentifier pvi = vi.getVersion();
        if (version == null) {
            return pvi == null;
        }
        if (pvi == null) {
            return false;
        }
        return version.equals((Object)Version.parseVersion((String)pvi.toString()));
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        SiteFeatureReaderType.checkComponentType(providerMatch.getProvider());
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new SiteFeatureReader(this, providerMatch);
    }

    public String getRecommendedMaterializer() {
        return "targetPlatform";
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        SiteFeatureReaderType.checkComponentType(provider);
        return new SiteFeatureFinder(provider, ctype, nodeQuery, monitor);
    }
}

