/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLCatalogReader
extends AbstractCatalogReader {
    private final URI m_uri;

    protected URLCatalogReader(URLCatalogReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super(readerType, rInfo);
        this.m_uri = readerType.getURI(rInfo);
    }

    protected final URI getURI() {
        return this.m_uri;
    }

    public URL getURL() throws CoreException {
        try {
            return this.m_uri.toURL();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        InputStream input;
        block5: {
            input = null;
            File source = FileUtils.getFile(this.getURL());
            if (source == null) break block5;
            boolean bl = new File(source, fileName).exists();
            IOUtils.close(input);
            return bl;
        }
        try {
            URL fileUrl = new URL(this.getURL(), fileName);
            input = CorePlugin.getDefault().openCachedURL(fileUrl, this.getConnectContext(), monitor);
        }
        catch (IOException e) {
            IOUtils.close(input);
            return false;
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return true;
    }

    @Override
    protected FileHandle innerGetContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        File source = FileUtils.getFile(this.getURL());
        if (source == null) {
            return super.innerGetContents(fileName, monitor);
        }
        monitor.beginTask(null, 5);
        try {
            File file = new File(source, fileName);
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            FileHandle fileHandle = new FileHandle(fileName, file, false);
            return fileHandle;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void innerGetMatchingRootFiles(Pattern pattern, List<FileHandle> files, IProgressMonitor monitor) throws CoreException, IOException {
        URL url = this.getURL();
        File source = FileUtils.getFile(url);
        if (source == null) {
            return;
        }
        String[] rootFiles = source.list();
        if (rootFiles == null) {
            return;
        }
        String[] stringArray = rootFiles;
        int n = rootFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            String rootFile = stringArray[n2];
            if (pattern.matcher(rootFile).matches() && (f = new File(source, rootFile)).isFile() && f.canRead()) {
                files.add(new FileHandle(rootFile, f, false));
            }
            ++n2;
        }
    }

    @Override
    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        URL url = this.getURL();
        File source = FileUtils.getFile(url);
        if (source == null) {
            return;
        }
        File[] rootFiles = source.listFiles();
        if (rootFiles == null) {
            return;
        }
        File[] fileArray = rootFiles;
        int n = rootFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File rootFile = fileArray[n2];
            String name = rootFile.getName();
            if (rootFile.isDirectory()) {
                name = String.valueOf(name) + "/";
            }
            files.add(name);
            ++n2;
        }
    }

    @Override
    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        URL url = this.getURL();
        File source = FileUtils.getFile(url);
        if (source == null) {
            throw new UnsupportedOperationException(Messages.Only_file_protocol_is_supported_at_this_time);
        }
        File destDir = destination.toFile();
        boolean success = false;
        try {
            if (destDir.toURI().toURL().equals(url)) {
                success = true;
                return;
            }
            try {
                FileUtils.deepCopy(source, destDir, ConflictResolution.UPDATE, monitor);
                success = true;
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            if (!success) {
                try {
                    FileUtils.deleteRecursive(destDir, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        T t;
        InputStream input = null;
        monitor.beginTask(fileName, 2);
        try {
            String fullName;
            File source = FileUtils.getFile(this.getURL());
            if (source != null) {
                File file = new File(source, fileName);
                input = new FileInputStream(file);
                fullName = file.getAbsolutePath();
            } else {
                URL fileUrl = new URL(this.getURL(), fileName);
                input = CorePlugin.getDefault().openCachedURL(fileUrl, this.getConnectContext(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                fullName = fileUrl.toString();
            }
            input = new BufferedInputStream(input);
            t = consumer.consumeStream(this, fullName, input, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        monitor.done();
        return t;
    }
}

