/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.IResolverFactory;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.resolver.ResolverFactoryMaintainer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class MainResolver
implements IResolver {
    private static final int MAX_ITERATIONS = 8;
    private final ResolutionContext m_context;
    private boolean m_recursiveResolve = true;

    public MainResolver(ResolutionContext context) {
        this.m_context = context;
    }

    public ResolutionContext getContext() {
        return this.m_context;
    }

    public boolean isRecursiveResolve() {
        return this.m_recursiveResolve;
    }

    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.m_context.logDecision(request, decisionType, args);
    }

    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.m_context.logDecision(decisionType, args);
    }

    public BillOfMaterials resolve(ComponentRequest request, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = this.m_context.getNodeQuery(request);
        BillOfMaterials bom = BillOfMaterials.create(new UnresolvedNode(query.getQualifiedDependency()), this.m_context.getComponentQuery());
        return this.resolveRemaining(bom, monitor);
    }

    public BillOfMaterials resolve(IProgressMonitor monitor) throws CoreException {
        return this.resolve(this.m_context.getComponentQuery().getExpandedRootRequest(this.m_context), monitor);
    }

    public BillOfMaterials resolveRemaining(BillOfMaterials bom, IProgressMonitor monitor) throws CoreException {
        if (bom.isFullyResolved(this.m_context)) {
            return bom;
        }
        this.m_context.addTagInfo(bom.getRequest(), bom.getQuery().getTagInfo());
        IResolverFactory[] resolverFactories = ResolverFactoryMaintainer.getInstance().getActiveResolverFactories();
        int numFactories = resolverFactories.length;
        if (numFactories == 1) {
            IResolverFactory factory = resolverFactories[0];
            this.logDecision(ResolverDecisionType.USING_RESOLVER, factory.getId());
            bom = factory.createResolver(this.m_context).resolveRemaining(bom, monitor);
        } else {
            monitor.beginTask(null, numFactories * 100);
            boolean continueOnError = this.m_context.isContinueOnError();
            boolean silentStatus = this.m_context.isSilentStatus();
            this.m_context.setContinueOnError(true);
            this.m_context.setSilentStatus(true);
            try {
                IStatus status;
                IResolver[] resolvers = new IResolver[numFactories];
                int idx = 0;
                while (idx < numFactories) {
                    resolvers[idx] = resolverFactories[idx].createResolver(this.m_context);
                    ++idx;
                }
                int iteration = 0;
                while (iteration < 8) {
                    BillOfMaterials bomAtIterationStart = bom;
                    int idx2 = 0;
                    while (idx2 < numFactories) {
                        IResolver resolver = resolvers[idx2];
                        this.logDecision(ResolverDecisionType.USING_RESOLVER, resolverFactories[idx2].getId());
                        resolver.setRecursiveResolve(this.m_recursiveResolve);
                        BillOfMaterials newBom = resolver.resolveRemaining(bom, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                        if (!bom.contentEqual(newBom)) {
                            if (idx2 == 0) {
                                bomAtIterationStart = bom;
                            }
                            bom = newBom;
                            if (!this.m_recursiveResolve || bom.isFullyResolved(this.m_context)) {
                                iteration = 8;
                                break;
                            }
                        }
                        ++idx2;
                    }
                    if (bomAtIterationStart.equals(bom)) break;
                    ++iteration;
                }
                if (bom.isFullyResolved(this.m_context)) {
                    this.m_context.clearStatus();
                } else if (!continueOnError && (status = this.m_context.getStatus()).getSeverity() == 4) {
                    this.m_context.clearStatus();
                    List<ComponentRequest> unresolvedList = bom.getUnresolvedList();
                    int top = unresolvedList.size();
                    if (top == 0) {
                        throw new CoreException(status);
                    }
                    StringBuilder bld = new StringBuilder();
                    bld.append(Messages.Unable_to_resolve);
                    int idx3 = 0;
                    while (idx3 < top) {
                        if (idx3 > 0) {
                            bld.append(", ");
                        }
                        unresolvedList.get(idx3).toString(bld);
                        ++idx3;
                    }
                    throw BuckminsterException.fromMessage((String)bld.toString(), (Object[])new Object[0]);
                }
            }
            finally {
                this.m_context.setContinueOnError(continueOnError);
                this.m_context.setSilentStatus(silentStatus);
                monitor.done();
            }
        }
        return bom;
    }

    public void setRecursiveResolve(boolean flag) {
        this.m_recursiveResolve = flag;
    }
}

