/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolverBackchannel;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionContext
extends RMContext
implements IResolverBackchannel {
    private final ComponentQuery m_componentQuery;
    private HashMap<String, GeneratorNode> m_generators;
    private final ResolutionContext m_parentContext;
    private final HashMap<ComponentRequest, List<ResolverDecision>> m_decisionLog = new HashMap();

    public ResolutionContext(ComponentQuery componentQuery) {
        this(componentQuery, null);
    }

    public ResolutionContext(ComponentQuery componentQuery, ResolutionContext parentContext) {
        super((Map<String, ? extends Object>)(parentContext == null ? componentQuery.getGlobalProperties() : new UnmodifiableMapUnion<String, Object>(componentQuery.getGlobalProperties(), parentContext)));
        this.m_componentQuery = componentQuery;
        this.m_parentContext = parentContext;
    }

    public ResolutionContext(MaterializationSpec mspec, ComponentQuery componentQuery) {
        super((Map<String, ? extends Object>)new UnmodifiableMapUnion<String, String>(componentQuery.getGlobalProperties(), mspec.getProperties()));
        this.m_componentQuery = componentQuery;
        this.m_parentContext = null;
    }

    @Override
    public synchronized void addRequestStatus(IComponentRequest request, IStatus resolveStatus) {
        if (this.m_parentContext != null) {
            this.m_parentContext.addRequestStatus(request, resolveStatus);
        } else {
            super.addRequestStatus(request, resolveStatus);
        }
    }

    @Override
    public synchronized void clearStatus() {
        if (this.m_parentContext != null) {
            this.m_parentContext.clearStatus();
        } else {
            super.clearStatus();
        }
    }

    @Override
    public synchronized Map<String, String> getBindingProperties() {
        return this.m_parentContext != null ? this.m_parentContext.getBindingProperties() : super.getBindingProperties();
    }

    @Override
    public ComponentQuery getComponentQuery() {
        return this.m_componentQuery;
    }

    public synchronized List<ResolverDecision> getDecisionLog(IComponentRequest request) {
        if (this.m_parentContext != null) {
            return this.m_parentContext.getDecisionLog(request);
        }
        return Utils.createUnmodifiableList((Collection)this.m_decisionLog.get(request));
    }

    public GeneratorNode getGeneratorNode(String name) {
        GeneratorNode node;
        if (this.m_generators != null && (node = this.m_generators.get(name)) != null) {
            return node;
        }
        return this.m_parentContext == null ? null : this.m_parentContext.getGeneratorNode(name);
    }

    @Override
    public Map<String, ? extends Object> getProperties(ComponentName cName) {
        IAdvisorNode parentNode = null;
        IAdvisorNode node = null;
        Map<String, ? extends Object> p = super.getProperties(cName);
        if (this.m_parentContext != null) {
            parentNode = this.m_parentContext.getComponentQuery().getMatchingNode(cName, this);
        }
        node = this.getComponentQuery().getMatchingNode(cName, this);
        if (parentNode == null && node == null) {
            return p;
        }
        if (parentNode != null) {
            p = new UnmodifiableMapUnion<String, Object>(parentNode.getProperties(), p);
        }
        if (node != null && node != parentNode) {
            p = new UnmodifiableMapUnion<String, Object>(node.getProperties(), p);
        }
        return p;
    }

    @Override
    public synchronized IStatus getStatus() {
        return this.m_parentContext != null ? this.m_parentContext.getStatus() : super.getStatus();
    }

    @Override
    public synchronized Map<UUID, Object> getUserCache() {
        return this.m_parentContext != null ? this.m_parentContext.getUserCache() : super.getUserCache();
    }

    @Override
    public synchronized boolean isContinueOnError() {
        return this.m_parentContext != null ? this.m_parentContext.isContinueOnError() : super.isContinueOnError();
    }

    @Override
    public synchronized ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        if (this.m_parentContext != null) {
            return this.m_parentContext.logDecision(request, decisionType, args);
        }
        List<ResolverDecision> decisions = this.m_decisionLog.get(request);
        if (decisions == null) {
            decisions = new ArrayList<ResolverDecision>();
            this.m_decisionLog.put(request, decisions);
        }
        ResolverDecision decision = new ResolverDecision(request, decisionType, args);
        decisions.add(decision);
        Logger logger = CorePlugin.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("%s: %s", new Object[]{request, decision.toString()});
        }
        return decision;
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.logDecision(this.getComponentQuery().getExpandedRootRequest(this), decisionType, args);
    }

    @Override
    public void setContinueOnError(boolean flag) {
        if (this.m_parentContext != null) {
            this.m_parentContext.setContinueOnError(flag);
        } else {
            super.setContinueOnError(flag);
        }
    }

    public void setGenerators(CSpec cspec, Collection<? extends IGenerator> generators) {
        for (IGenerator iGenerator : generators) {
            if (this.m_generators == null) {
                this.m_generators = new HashMap();
            }
            this.m_generators.put(iGenerator.getGenerates(), new GeneratorNode(cspec, iGenerator));
        }
    }
}

