/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.FibonacciMonitorWrapper;
import org.eclipse.buckminster.core.helpers.JobBlocker;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.IResourceMapResolverFactory;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.resolver.ResolverNode;
import org.eclipse.buckminster.core.resolver.ResolverNodeWithJob;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

public class ResourceMapResolver
extends LocalResolver
implements IJobChangeListener,
IResolver {
    private boolean m_singleThreaded = false;
    private boolean m_holdQueue = false;
    private static int s_jobCounter = 0;
    private final ArrayList<IProgressMonitor> m_jobMonitors = new ArrayList();
    private final IResourceMapResolverFactory m_factory;
    private IProgressMonitor m_topMonitor;
    private final LinkedList<ResolverNodeWithJob> m_waitQueue = new LinkedList();

    public ResourceMapResolver(IResourceMapResolverFactory factory, ResolutionContext context, boolean singleThreaded) throws CoreException {
        super(context);
        this.m_factory = factory;
        this.m_singleThreaded = singleThreaded;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(IJobChangeEvent event) {
        ResolverNodeWithJob node;
        ResolverNodeWithJob.NodeResolutionJob job = (ResolverNodeWithJob.NodeResolutionJob)event.getJob();
        job.removeJobChangeListener(this);
        ResolverNodeWithJob resolverNodeWithJob = node = job.getNode();
        synchronized (resolverNodeWithJob) {
            node.setScheduled(false);
            if (node.isInvalidated() && !node.isForceUnresolved()) {
                this.schedule(node);
            }
        }
    }

    public BillOfMaterials resolve(ComponentRequest request, IProgressMonitor monitor) throws CoreException {
        this.beginTopMonitor(monitor);
        try {
            ResolutionContext ctx = this.getContext();
            ComponentQuery query = ctx.getComponentQuery();
            ResolverNodeWithJob topNode = (ResolverNodeWithJob)this.getResolverNode(ctx, new QualifiedDependency(request, query.getAttributes(request, ctx)), null);
            if (this.m_singleThreaded) {
                this.beginTopMonitor(monitor);
                this.schedule(topNode);
                this.endTopMonitor();
            } else {
                this.schedule(topNode);
                this.waitForCompletion(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
            BillOfMaterials billOfMaterials = this.createBillOfMaterials(topNode);
            return billOfMaterials;
        }
        finally {
            this.endTopMonitor();
        }
    }

    public BillOfMaterials resolveRemaining(BillOfMaterials bom, IProgressMonitor monitor) throws CoreException {
        if (bom.isFullyResolved(this.getContext())) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return bom;
        }
        this.beginTopMonitor(monitor);
        try {
            ComponentQuery cquery = bom.getQuery();
            ResolutionContext context = this.getContext();
            if (cquery != null && !cquery.equals(context.getComponentQuery())) {
                context = new ResolutionContext(cquery, context);
            }
            ResolverNodeWithJob topNode = (ResolverNodeWithJob)this.getResolverNode(context, bom.getQualifiedDependency(), bom.getTagInfo());
            this.m_holdQueue = true;
            if (topNode.rebuildTree(bom)) {
                BillOfMaterials newBom;
                this.m_holdQueue = false;
                if (this.m_singleThreaded) {
                    IStatus status = context.getStatus();
                    if (status.getSeverity() == 4 && !context.isContinueOnError()) {
                        throw new CoreException(status);
                    }
                } else {
                    this.scheduleNext();
                    this.waitForCompletion(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                if (!(newBom = this.createBillOfMaterials(topNode)).contentEqual(bom)) {
                    bom = newBom;
                }
            }
            BillOfMaterials billOfMaterials = bom;
            return billOfMaterials;
        }
        finally {
            this.m_holdQueue = false;
            this.endTopMonitor();
        }
    }

    public synchronized void running(IJobChangeEvent event) {
        if (this.m_topMonitor != null) {
            MonitorUtils.worked((IProgressMonitor)this.m_topMonitor, (int)1);
        }
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    synchronized void addJobMonitor(IProgressMonitor monitor) {
        if (this.m_singleThreaded) {
            return;
        }
        if (this.m_topMonitor == null || this.m_topMonitor.isCanceled()) {
            monitor.setCanceled(true);
            return;
        }
        int idx = this.m_jobMonitors.size();
        while (--idx >= 0) {
            if (this.m_jobMonitors.get(idx) != monitor) continue;
            return;
        }
        this.m_jobMonitors.add(monitor);
    }

    synchronized void cancelTopMonitor() {
        if (this.m_topMonitor != null) {
            this.m_topMonitor.setCanceled(true);
        }
    }

    ResolverNode createResolverNode(ResolutionContext context, QualifiedDependency qDep, String requestorInfo) {
        return new ResolverNodeWithJob(this, context, qDep, requestorInfo);
    }

    BOMNode innerResolve(NodeQuery query, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            BOMNode node = null;
            if (this.m_factory.isLocalResolve()) {
                query.logDecision(ResolverDecisionType.USING_RESOLVER, "Local resolver");
                node = this.localResolve(query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
            } else {
                query.logDecision(ResolverDecisionType.RESOLVER_REJECTED, "All local resolvers");
                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
            }
            if (node == null && query.useResolutionService()) {
                ComponentQuery cquery = query.getComponentQuery();
                URL rmapURL = cquery.getResolvedResourceMapURL();
                ResourceMap rmap = this.m_factory.getResourceMap(this.getContext(), rmapURL, cquery.getConnectContext());
                query.logDecision(ResolverDecisionType.USING_RESOURCE_MAP, rmapURL);
                node = rmap.resolve(query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)95));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)95);
            }
            BOMNode bOMNode = node;
            return bOMNode;
        }
        catch (CoreException e) {
            ResolutionContext context = this.getContext();
            if (!((RMContext)context).isContinueOnError()) {
                throw e;
            }
            ((RMContext)context).addRequestStatus(query.getComponentRequest(), e.getStatus());
            return null;
        }
        finally {
            monitor.done();
        }
    }

    synchronized void removeJobMonitor(IProgressMonitor monitor) {
        if (this.m_singleThreaded) {
            return;
        }
        int idx = this.m_jobMonitors.size();
        while (--idx >= 0) {
            if (this.m_jobMonitors.get(idx) != monitor) continue;
            this.m_jobMonitors.remove(idx);
            break;
        }
    }

    synchronized void resolutionPartDone() {
        if (this.m_singleThreaded) {
            return;
        }
        --s_jobCounter;
        this.scheduleNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean schedule(ResolverNodeWithJob node) {
        ResolverNodeWithJob resolverNodeWithJob = node;
        synchronized (resolverNodeWithJob) {
            block7: {
                if (!node.isScheduled() && !node.isResolved()) break block7;
                return false;
            }
            node.setScheduled(true);
        }
        if (this.m_singleThreaded) {
            node.run(MonitorUtils.subMonitor((IProgressMonitor)this.m_topMonitor, (int)1));
            node.setScheduled(false);
        } else {
            this.pushOnWaitQueue(node);
            if (!this.m_holdQueue) {
                this.scheduleNext();
            }
        }
        return true;
    }

    private synchronized void beginTopMonitor(IProgressMonitor monitor) {
        monitor = new FibonacciMonitorWrapper((IProgressMonitor)monitor);
        monitor.beginTask(null, 50);
        this.m_topMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllJobs() {
        Cloneable cloneable = this.m_waitQueue;
        synchronized (cloneable) {
            this.m_waitQueue.clear();
        }
        cloneable = this;
        synchronized (cloneable) {
            int idx = this.m_jobMonitors.size();
            while (--idx >= 0) {
                this.m_jobMonitors.get(idx).setCanceled(true);
            }
            if (this.m_topMonitor != null) {
                this.m_topMonitor.setCanceled(true);
            }
        }
    }

    private synchronized void endTopMonitor() {
        this.m_topMonitor.done();
        this.m_topMonitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolverNodeWithJob popWaitQueue() {
        LinkedList<ResolverNodeWithJob> linkedList = this.m_waitQueue;
        synchronized (linkedList) {
            return this.m_waitQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushOnWaitQueue(ResolverNodeWithJob node) {
        LinkedList<ResolverNodeWithJob> linkedList = this.m_waitQueue;
        synchronized (linkedList) {
            this.m_waitQueue.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleNext() {
        ArrayList<ResolverNodeWithJob> nodes = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            int jobsToSchedule = this.m_factory.getResolverThreadsMax() - s_jobCounter;
            while (--jobsToSchedule >= 0) {
                ResolverNodeWithJob node = this.popWaitQueue();
                if (node == null) break;
                if (nodes == null) {
                    nodes = new ArrayList<ResolverNodeWithJob>();
                }
                nodes.add(node);
                ++s_jobCounter;
            }
        }
        if (nodes == null) {
            return false;
        }
        int top = nodes.size();
        int idx = 0;
        while (idx < top) {
            ResolverNodeWithJob.NodeResolutionJob job = ((ResolverNodeWithJob)nodes.get(idx)).getJob();
            job.addJobChangeListener(this);
            job.schedule();
            ++idx;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForCompletion(IProgressMonitor monitor) throws CoreException {
        JobBlocker jobBlocker = new JobBlocker();
        jobBlocker.addNameBlock(Messages.Building_workspace);
        jobBlocker.addNameBlock(Messages.Periodic_workspace_save);
        monitor.beginTask(null, -1);
        try {
            IStatus status;
            ResolutionContext context = this.getContext();
            try {
                block6: while (true) {
                    Job.getJobManager().join((Object)this, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                    if (this.m_waitQueue.isEmpty()) {
                        status = ((RMContext)context).getStatus();
                        break;
                    }
                    while (true) {
                        if (this.scheduleNext()) continue block6;
                        Thread.sleep(100L);
                    }
                    break;
                }
            }
            catch (OperationCanceledException e) {
                status = Status.CANCEL_STATUS;
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
            }
            if (status.getSeverity() == 8) {
                this.cancelAllJobs();
                throw new OperationCanceledException();
            }
            if (status.getSeverity() != 4) return;
            if (((RMContext)context).isContinueOnError()) return;
            ((RMContext)context).clearStatus();
            throw new CoreException(status);
        }
        finally {
            monitor.done();
            jobBlocker.release();
        }
    }
}

