/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.FormatHandler;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.rmap.parser.DigestHandler;
import org.eclipse.buckminster.core.rmap.parser.SearchPathHandler;
import org.eclipse.buckminster.core.rmap.parser.URIMatcherHandler;
import org.eclipse.buckminster.core.rmap.parser.VersionConverterHandler;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.MissingRequiredAttributeException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProviderHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "provider";
    private DocumentationHandler m_documentationHandler;
    private FormatHandler m_uriHandler;
    private DigestHandler m_digestHandler;
    private VersionConverterHandler m_versionConverterHandler;
    private URIMatcherHandler m_uriMetaDataHandler;
    private URIMatcher m_uriMatcher;
    private Documentation m_documentation;
    private String m_readerType;
    private String[] m_componentTypes;
    private boolean m_source;
    private boolean m_mutable;
    private Format m_uriFormat;
    private Format m_digestFormat;
    private String m_digestAlgorithm;
    private VersionConverterDesc m_versionConverter;
    private Filter m_resolutionFilter;

    public ProviderHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_uriHandler) {
            this.m_uriFormat = (Format)this.m_uriHandler.getValueHolder();
        } else if (child == this.m_digestHandler) {
            this.m_digestFormat = (Format)this.m_digestHandler.getValueHolder();
            this.m_digestAlgorithm = this.m_digestHandler.getAlgorithm();
        } else if (child == this.m_versionConverterHandler) {
            this.m_versionConverter = this.m_versionConverterHandler.getVersionConverter();
        } else if (child == this.m_documentationHandler) {
            this.m_documentation = this.m_documentationHandler.createDocumentation();
        } else if (child == this.m_uriMetaDataHandler) {
            try {
                this.m_uriMatcher = this.m_uriMetaDataHandler.createURIMetaData();
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), e);
            }
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("uri".equals(localName)) {
            if (this.m_uriHandler == null) {
                this.m_uriHandler = new FormatHandler((AbstractHandler)this);
            }
            ch = this.m_uriHandler;
        } else if ("digest".equals(localName)) {
            if (this.m_digestHandler == null) {
                this.m_digestHandler = new DigestHandler((AbstractHandler)this);
            }
            ch = this.m_digestHandler;
        } else if ("documentation".equals(localName)) {
            if (this.m_documentationHandler == null) {
                this.m_documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.m_documentationHandler;
        } else if ("versionConverter".equals(localName)) {
            if (this.m_versionConverterHandler == null) {
                this.m_versionConverterHandler = new VersionConverterHandler((AbstractHandler)this);
            }
            ch = this.m_versionConverterHandler;
        } else if ("matcher".equals(localName)) {
            if (this.m_uriMetaDataHandler == null) {
                this.m_uriMetaDataHandler = new URIMatcherHandler((AbstractHandler)this);
            }
            ch = this.m_uriMetaDataHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public Provider getProvider() {
        return new Provider(this.getSearchPath(), this.m_readerType, this.m_componentTypes, this.m_versionConverter, this.m_uriFormat, this.m_digestFormat, this.m_digestAlgorithm, this.m_resolutionFilter, this.m_mutable, this.m_source, this.m_uriMatcher, this.m_documentation);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        String resFilter;
        this.m_readerType = this.getStringValue(attrs, "readerType");
        this.m_componentTypes = null;
        String tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"componentTypes");
        if (tmp == null) {
            ArrayList<String> expanded;
            tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
            if (tmp == null) {
                throw new MissingRequiredAttributeException(this.getTAG(), "componentTypes", this.getDocumentLocator());
            }
            this.logAttributeDeprecation(this.getTAG(), "componentType", "componentTypes");
            boolean canManageBundle = true;
            boolean canManageFeature = true;
            String[] managedCategories = TextUtils.split(ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"managedCategories"), ",");
            if (managedCategories.length > 0) {
                this.logAttributeDeprecation(this.getTAG(), "managedCategories", "componentTypes");
                canManageBundle = false;
                canManageFeature = false;
                String[] stringArray = managedCategories;
                int n = managedCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    String category = stringArray[n2];
                    if ("plugin".equals(category)) {
                        canManageBundle = true;
                    } else if ("feature".equals(category)) {
                        canManageFeature = true;
                    }
                    ++n2;
                }
            }
            if (tmp.equals("eclipse.project")) {
                expanded = new ArrayList<String>(3);
                if (canManageBundle) {
                    expanded.add("osgi.bundle");
                }
                if (canManageFeature) {
                    expanded.add("eclipse.feature");
                }
                expanded.add("buckminster");
                this.m_componentTypes = expanded.toArray(new String[expanded.size()]);
            } else if (tmp.equals("eclipse.installed")) {
                expanded = new ArrayList(3);
                if (canManageBundle) {
                    expanded.add("osgi.bundle");
                }
                if (canManageFeature) {
                    expanded.add("eclipse.feature");
                }
                this.m_componentTypes = expanded.toArray(new String[expanded.size()]);
            }
        } else if ("eclipse.project".equals(tmp)) {
            tmp = "osgi.bundle,eclipse.feature,buckminster";
        }
        if (this.m_componentTypes == null) {
            this.m_componentTypes = TextUtils.split(tmp, ",");
        }
        this.m_mutable = ProviderHandler.getOptionalBooleanValue((Attributes)attrs, (String)"mutable", (boolean)true);
        this.m_source = ProviderHandler.getOptionalBooleanValue((Attributes)attrs, (String)"source", (boolean)true);
        tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"space");
        if (tmp != null) {
            tmp = "(buckminster.spacepath=" + tmp + ')';
        }
        if ((resFilter = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"resolutionFilter")) == null) {
            resFilter = tmp;
        } else if (tmp != null) {
            resFilter = "(&" + resFilter + tmp + ')';
        }
        if (resFilter != null) {
            try {
                this.m_resolutionFilter = FilterFactory.newInstance((String)resFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        } else {
            this.m_resolutionFilter = null;
        }
        this.m_uriFormat = null;
        this.m_digestFormat = null;
        this.m_digestAlgorithm = null;
        this.m_versionConverter = null;
        this.m_uriMatcher = null;
        this.m_documentation = null;
    }

    protected final String[] getComponentTypes() {
        return this.m_componentTypes;
    }

    protected final String getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    protected final Format getDigestFormat() {
        return this.m_digestFormat;
    }

    protected final Documentation getDocumentation() {
        return this.m_documentation;
    }

    protected final String getReaderType() {
        return this.m_readerType;
    }

    protected final Filter getResolutionFilter() {
        return this.m_resolutionFilter;
    }

    protected SearchPath getSearchPath() {
        SearchPath searchPath = null;
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof SearchPathHandler) {
            searchPath = ((SearchPathHandler)parent).getSearchPath();
        }
        return searchPath;
    }

    protected final Format getUriFormat() {
        return this.m_uriFormat;
    }

    protected final VersionConverterDesc getVersionConverter() {
        return this.m_versionConverter;
    }

    protected final boolean isMutable() {
        return this.m_mutable;
    }

    protected final boolean isSource() {
        return this.m_source;
    }
}

