/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.buckminster.core.parser.AbstractParser;
import org.eclipse.buckminster.core.parser.ParserFactory;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapHandler;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapParser
extends AbstractParser<ResourceMap> {
    private ResourceMap m_resourceMap;
    private URL m_contextURL;

    public ResourceMapParser(List<ParserFactory.ParserExtension> parserExtensions, boolean validating) throws CoreException {
        super(parserExtensions, new String[]{"http://www.w3.org/1999/xhtml", "http://www.w3.org/XML/1998/namespace", "http://www.eclipse.org/buckminster/Common-1.0", "http://www.eclipse.org/buckminster/RMap-1.0"}, new String[]{"/xhtml1-strict.xsd", "/xml-2001.xsd", "/common-1.0.xsd", "/rmap-1.0.xsd"}, validating);
    }

    @Override
    public ResourceMap parse(String systemID, InputStream input) throws CoreException {
        try {
            this.m_contextURL = URLUtils.normalizeToURL((String)systemID);
        }
        catch (MalformedURLException e) {
            this.m_contextURL = null;
        }
        this.parseInput(systemID, input);
        return this.m_resourceMap;
    }

    void setResourceMap(ResourceMap resourceMap) {
        this.m_resourceMap = resourceMap;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if ("rmap".equals(localName)) {
            String type = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            ResourceMapHandler rmh = this.createContentHandler((AbstractHandler)this, ResourceMapHandler.class, uri, type);
            rmh.setContextURL(this.m_contextURL);
            this.pushHandler(rmh, attrs);
        } else {
            super.startElement(uri, localName, qName, attrs);
        }
    }
}

