/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.parser.ProviderHandler;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SearchPathHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    static final String TAG = "searchPath";
    private SearchPath m_searchPath;

    public SearchPathHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof ProviderHandler) {
            this.m_searchPath.addProvider(((ProviderHandler)child).getProvider());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ProviderHandler ch = "provider".equals(localName) ? this.createContentHandler(ProviderHandler.class, uri, attrs) : super.createHandler(uri, localName, attrs);
        return ch;
    }

    SearchPath getSearchPath() {
        return this.m_searchPath;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        ResourceMap rmap = ((ResourceMapHandler)this.getParentHandler()).getResourceMap();
        this.m_searchPath = new SearchPath(rmap, this.getStringValue(attrs, "name"));
        rmap.addSearchPath(this.m_searchPath);
    }
}

