/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;

public abstract class AbstractConverter
extends AbstractExtension
implements IVersionConverter {
    private static final BidirectionalTransformer[] s_noTransformers = new BidirectionalTransformer[0];
    private BidirectionalTransformer[] m_transformers = s_noTransformers;
    private VersionFormat m_versionFormat = this.getDefaultVersionFormat();

    public VersionFormat getVersionFormat() {
        return this.m_versionFormat;
    }

    public final void setTransformers(BidirectionalTransformer[] transformers) {
        this.m_transformers = transformers == null ? s_noTransformers : transformers;
    }

    public final void setVersionFormat(VersionFormat versionFormat) {
        this.m_versionFormat = versionFormat == null ? this.getDefaultVersionFormat() : versionFormat;
    }

    protected String createSelectorComponent(Version source) throws CoreException {
        String result = source.toString();
        if (this.m_transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.m_transformers;
            int n = this.m_transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformFrom(result);
                if (transformed != null) {
                    matchFound = true;
                    result = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        return result;
    }

    protected Version createVersionFromSelectorComponent(String source) throws CoreException {
        if (this.m_transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.m_transformers;
            int n = this.m_transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformTo(source);
                if (transformed != null) {
                    matchFound = true;
                    source = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        try {
            return this.m_versionFormat.parse(source);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected abstract VersionFormat getDefaultVersionFormat();
}

