/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.opml.builder.OPMLBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderMatch
implements Comparable<ProviderMatch> {
    private IComponentType m_componentType;
    private final Provider m_originalProvider;
    private Provider m_provider;
    private final ProviderScore m_providerScore;
    private final NodeQuery m_query;
    private VersionMatch m_versionMatch;
    private Map<String, String> m_matcherMap;
    private String m_repositoryURI;

    public ProviderMatch(Provider provider, IComponentType componentType, VersionMatch versionMatch, NodeQuery query) {
        this(provider, componentType, versionMatch, ProviderScore.PREFERRED, query);
    }

    public ProviderMatch(Provider provider, IComponentType componentType, VersionMatch versionMatch, ProviderScore providerScore, NodeQuery query) {
        this.m_provider = provider;
        this.m_originalProvider = provider;
        this.m_componentType = componentType;
        this.m_versionMatch = versionMatch == null ? VersionMatch.DEFAULT : versionMatch;
        this.m_providerScore = providerScore;
        this.m_query = query;
    }

    @Override
    public int compareTo(ProviderMatch o) {
        int versionCompare = this.m_query.compare(this.m_versionMatch, o.getVersionMatch());
        return versionCompare == 0 ? this.m_providerScore.compareTo(o.getProviderScore()) : versionCompare;
    }

    public CSpecBuilder createCSpec() {
        CSpecBuilder bld = new CSpecBuilder();
        ComponentRequest request = this.m_query.getComponentRequest();
        bld.setName(request.getName());
        bld.setComponentTypeID(request.getComponentTypeID());
        bld.setVersion(this.m_versionMatch.getVersion());
        return bld;
    }

    public ResolutionBuilder createResolution(CSpecBuilder cspecBuilder, OPMLBuilder opmlBuilder, boolean unpack) throws CoreException {
        ResolutionBuilder resBld = new ResolutionBuilder(cspecBuilder, opmlBuilder);
        Provider provider = this.getProvider();
        NodeQuery nq = this.getNodeQuery();
        resBld.setMaterializable(true);
        resBld.setComponentTypeId(this.getComponentType().getId());
        resBld.getRequest().initFrom(nq.getComponentRequest());
        resBld.setAttributes(nq.getRequiredAttributes());
        resBld.setProvider(provider);
        resBld.setVersionMatch(this.getVersionMatch());
        resBld.setRepository(this.getRepositoryURI());
        resBld.setUnpack(unpack);
        return resBld;
    }

    public String getComponentName() {
        return this.m_query.getComponentRequest().getName();
    }

    public IComponentType getComponentType() {
        return this.m_componentType;
    }

    public IConnectContext getConnectContext() {
        IConnectContext cctx = this.m_provider.getConnectContext();
        if (cctx == null) {
            cctx = this.getNodeQuery().getComponentQuery().getConnectContext();
        }
        return cctx;
    }

    public Map<String, String> getMatcherMap() {
        return this.m_matcherMap;
    }

    public NodeQuery getNodeQuery() {
        return this.m_query;
    }

    public Provider getOriginalProvider() {
        return this.m_originalProvider;
    }

    public Provider getProvider() {
        return this.m_provider;
    }

    public final ProviderScore getProviderScore() {
        return this.m_providerScore;
    }

    public NodeQuery getQuery() {
        return this.m_query;
    }

    public IComponentReader getReader(IProgressMonitor monitor) throws CoreException {
        return this.getReaderType().getReader(this, monitor);
    }

    public IReaderType getReaderType() throws CoreException {
        return this.m_provider.getReaderType();
    }

    public synchronized String getRepositoryURI() {
        if (this.m_repositoryURI == null) {
            this.m_repositoryURI = this.m_provider.getURI(this.m_query.getProperties());
        }
        return this.m_repositoryURI;
    }

    public String getUniqueKey() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_provider.getId());
        bld.append('[');
        ComponentRequest rq = this.m_query.getComponentRequest();
        bld.append(rq.getName());
        String type = rq.getComponentTypeID();
        if (type != null) {
            bld.append(':');
            bld.append(type);
        }
        this.m_versionMatch.toString(bld);
        bld.append(']');
        return bld.toString();
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        return this.m_provider.getVersionConverter();
    }

    public VersionMatch getVersionMatch() {
        return this.m_versionMatch;
    }

    public void setComponentType(IComponentType componentType) {
        this.m_componentType = componentType;
    }

    public void setMatcherMap(Map<String, String> matcherMap) {
        this.m_matcherMap = matcherMap;
    }

    public synchronized void setProvider(Provider provider) {
        this.m_provider = provider;
        this.m_repositoryURI = null;
    }

    public synchronized void setRepositoryURI(String repositoryURI) {
        this.m_repositoryURI = repositoryURI;
    }

    public void setVersionMatch(VersionMatch versionMatch) {
        this.m_versionMatch = versionMatch;
    }

    public String toString() {
        return this.getUniqueKey();
    }
}

