/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionQualifierGenerator
extends AbstractExtension
implements IQualifierGenerator {
    public static String FORMAT_PROPERTY = "generator.lastRevision.format";
    public static String DEFAULT_FORMAT = "r{0,number,##################}";

    @Override
    public Version generateQualifier(IActionContext context, ComponentIdentifier cid, List<ComponentIdentifier> dependencies) throws CoreException {
        Version currentVersion = cid.getVersion();
        if (currentVersion == null) {
            return null;
        }
        try {
            IPath location = WorkspaceInfo.getComponentLocation(cid);
            IReaderType readerType = AbstractReaderType.getTypeForResource((IResource)WorkspaceInfo.getProject(cid));
            if (readerType == null) {
                return currentVersion;
            }
            long revision = readerType.getLastRevision(location.toFile(), context.getCancellationMonitor());
            if (revision == -1L) {
                return currentVersion;
            }
            Map<String, ? extends Object> props = context.getProperties();
            String format = (String)props.get(FORMAT_PROPERTY);
            if (format == null) {
                format = DEFAULT_FORMAT;
            }
            MessageFormat mf = new MessageFormat(format);
            for (IComponentIdentifier iComponentIdentifier : dependencies) {
                String qualifier;
                Version depVer = iComponentIdentifier.getVersion();
                if (depVer == null || (qualifier = depVer.getQualifier()) == null) continue;
                try {
                    long depRev = ((Number)mf.parse(qualifier)[0]).longValue();
                    if (depRev <= revision) continue;
                    revision = depRev;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string2 = mf.format(new Object[]{new Long(revision)});
            string2 = currentVersion.getQualifier().replace("qualifier", string2);
            return VersionHelper.replaceQualifier(currentVersion, string2);
        }
        catch (MissingComponentException e) {
            return currentVersion;
        }
    }
}

