/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampQualifierGenerator
extends AbstractExtension
implements IQualifierGenerator {
    public static final String FORMAT_PROPERTY = "generator.lastModified.format";
    public static final String DEFAULT_FORMAT = "'v'yyyyMMddHHmm";
    public static final String[] commonFormats = new String[]{"'v'yyyyMMddHHmm", "'v'yyyyMMdd-HHmm", "'v'yyyyMMdd", "'I'yyyyMMddHHmm", "'I'yyyyMMdd-HHmm", "'I'yyyyMMdd"};
    public static final DateFormat[] commonFormatters;
    private static final long SANITY_THRESHOLD = 315792000000L;

    static {
        int idx = commonFormats.length;
        commonFormatters = new DateFormat[idx];
        while (--idx >= 0) {
            SimpleDateFormat dm = new SimpleDateFormat(commonFormats[idx]);
            dm.setTimeZone(DateAndTimeUtils.UTC);
            dm.setLenient(false);
            TimestampQualifierGenerator.commonFormatters[idx] = dm;
        }
    }

    private static Date getLastModification(ComponentIdentifier cid, IActionContext context) throws CoreException {
        IPath location = WorkspaceInfo.getComponentLocation(cid);
        IReaderType readerType = AbstractReaderType.getTypeForResource((IResource)WorkspaceInfo.getProject(cid));
        if (readerType == null) {
            return null;
        }
        return readerType.getLastModification(location.toFile(), context.getCancellationMonitor());
    }

    private static Date parseSaneDate(DateFormat mf, String str) throws ParseException {
        long now = System.currentTimeMillis();
        long sanePast = now - 315792000000L;
        Date dt = mf.parse(str);
        long tm = dt.getTime();
        if (tm > now || tm < sanePast) {
            throw new ParseException("Bogus", 0);
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Version generateQualifier(IActionContext context, ComponentIdentifier cid, List<ComponentIdentifier> dependencies) throws CoreException {
        Version currentVersion = cid.getVersion();
        if (currentVersion == null) {
            return null;
        }
        try {
            Date lastMod = TimestampQualifierGenerator.getLastModification(cid, context);
            if (lastMod == null) {
                return currentVersion;
            }
            Map<String, ? extends Object> props = context.getProperties();
            String format = (String)props.get(FORMAT_PROPERTY);
            if (format == null) {
                format = DEFAULT_FORMAT;
            }
            SimpleDateFormat mf = new SimpleDateFormat(format);
            mf.setTimeZone(DateAndTimeUtils.UTC);
            mf.setLenient(false);
            Iterator<ComponentIdentifier> iterator = dependencies.iterator();
            while (true) {
                String qualifier;
                if (!iterator.hasNext()) {
                    String newQual = mf.format(lastMod);
                    newQual = currentVersion.getQualifier().replace("qualifier", newQual);
                    return VersionHelper.replaceQualifier(currentVersion, newQual);
                }
                ComponentIdentifier dependency = iterator.next();
                Version depVer = dependency.getVersion();
                if (depVer == null || (qualifier = depVer.getQualifier()) == null) continue;
                Date depLastMod = null;
                try {
                    depLastMod = TimestampQualifierGenerator.parseSaneDate(mf, qualifier);
                }
                catch (ParseException e) {
                    DateFormat[] dateFormatArray = commonFormatters;
                    // MONITORENTER : commonFormatters
                    int idx = 0;
                    while (idx < commonFormatters.length) {
                        try {
                            depLastMod = TimestampQualifierGenerator.parseSaneDate(commonFormatters[idx], qualifier);
                            break;
                        }
                        catch (ParseException parseException) {
                            ++idx;
                        }
                    }
                    // MONITOREXIT : dateFormatArray
                }
                if (depLastMod == null) {
                    try {
                        depVer = Version.createOSGi((int)depVer.getMajor(), (int)depVer.getMinor(), (int)depVer.getMicro(), (String)"qualifier");
                        depLastMod = TimestampQualifierGenerator.getLastModification(new ComponentIdentifier(dependency.getName(), dependency.getComponentTypeID(), depVer), context);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (depLastMod == null || depLastMod.compareTo(lastMod) <= 0) continue;
                lastMod = depLastMod;
            }
        }
        catch (MissingComponentException e) {
            return currentVersion;
        }
    }
}

