/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Date;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VersionMatch
extends AbstractSaxableElement {
    public static final VersionMatch DEFAULT = new VersionMatch(null, null, -1L, null, null);
    public static final String TAG = "versionMatch";
    public static final String ATTR_ARTIFACT_INFO = "artifactInfo";
    public static final String ATTR_BRANCH_OR_TAG = "branchOrTag";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_TIMESTAMP = "timestamp";
    private final String m_artifactInfo;
    private final VersionSelector m_branchOrTag;
    private final long m_revision;
    private final Date m_timestamp;
    private final Version m_version;

    public VersionMatch(Version version, VersionSelector branchOrTag, long revision, Date timestamp, String artifactInfo) {
        this.m_version = version;
        if (branchOrTag != null && branchOrTag.isDefault()) {
            branchOrTag = null;
        }
        this.m_branchOrTag = branchOrTag;
        this.m_revision = revision;
        this.m_timestamp = timestamp;
        this.m_artifactInfo = artifactInfo;
    }

    public VersionMatch copyWithVersion(Version version) {
        if (Trivial.equalsAllowNull((Object)version, (Object)this.m_version)) {
            return this;
        }
        return new VersionMatch(version, this.m_branchOrTag, -1L, null, this.m_artifactInfo);
    }

    public String getArtifactInfo() {
        return this.m_artifactInfo;
    }

    public VersionSelector getBranchOrTag() {
        return this.m_branchOrTag;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public long getRevision() {
        return this.m_revision;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    public void toString(StringBuilder bld) {
        boolean needSep = false;
        if (this.m_version != null) {
            bld.append(VersionHelper.getHumanReadable(this.m_version));
            needSep = true;
        }
        if (this.m_branchOrTag != null) {
            if (needSep) {
                bld.append(':');
            }
            this.m_branchOrTag.toString(bld);
        }
        if (this.m_revision != -1L) {
            if (needSep) {
                bld.append(':');
            }
            bld.append('#');
            bld.append(this.m_revision);
        }
        if (this.m_timestamp != null) {
            bld.append(':');
            bld.append(DateAndTimeUtils.toISOFormat(this.m_timestamp));
        }
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_artifactInfo != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ARTIFACT_INFO, (String)this.m_artifactInfo);
        }
        if (this.m_branchOrTag != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BRANCH_OR_TAG, (String)this.m_branchOrTag.toString());
        }
        if (this.m_revision != -1L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REVISION, (String)Long.toString(this.m_revision));
        }
        if (this.m_timestamp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)DateAndTimeUtils.toISOFormat(this.m_timestamp));
        }
        if (this.m_version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)this.m_version.toString());
        }
    }
}

