/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.cvspkg.internal.CVSReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderSandbox;

public class CVSSession
implements Closeable {
    private final ICVSRepositoryLocation m_location;
    private final String m_moduleName;
    private Session m_readerSession;

    public CVSSession(String repositoryURI) throws CoreException {
        StringTokenizer tokenizer = new StringTokenizer(repositoryURI, ",");
        try {
            String module;
            String repo = tokenizer.nextToken();
            this.m_location = CVSReaderType.getLocationFromString(repo);
            String string = module = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (module != null && module.startsWith("/")) {
                module = module.substring(1);
            }
            this.m_moduleName = module;
        }
        catch (NoSuchElementException e) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.repository_URI_not_in_0_format, (Object)("<" + Messages.cvs_root + ">,<" + Messages.cvs_module + ">")), (Object[])new Object[0]);
        }
    }

    public synchronized void close() {
        if (this.m_readerSession != null) {
            this.m_readerSession.close();
            this.m_readerSession = null;
        }
    }

    public String getFilePrefix() {
        StringBuilder bld = new StringBuilder(this.m_location.getRootDirectory());
        bld.append('/');
        if (this.m_moduleName != null) {
            bld.append(this.m_moduleName);
            bld.append('/');
        }
        return bld.toString();
    }

    public final ICVSRepositoryLocation getLocation() {
        return this.m_location;
    }

    public final String getModuleName() {
        return this.m_moduleName;
    }

    public String getRepository() {
        String location = this.m_location.getLocation(false);
        if (this.m_moduleName == null) {
            return location;
        }
        return String.valueOf(location) + '/' + this.m_moduleName;
    }

    synchronized Session getReaderSession(IProgressMonitor monitor) throws CoreException {
        if (this.m_readerSession == null) {
            ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            this.m_readerSession = new Session(this.getLocation(), root, false);
            this.m_readerSession.open(monitor, false);
        }
        return this.m_readerSession;
    }

    RemoteFolderSandbox getSandbox(CVSTag tag) {
        return new RemoteFolderSandbox(null, this.getLocation(), this.getModuleName(), tag);
    }
}

