/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.model.tree;

import java.util.ArrayList;
import org.eclipse.buckminster.generic.model.tree.AbstractTreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;

public abstract class AbstractTreeParentDataNode
extends AbstractTreeDataNode
implements ITreeParentDataNode {
    private ArrayList<ITreeDataNode> m_children = new ArrayList();

    public void addChild(ITreeDataNode child) {
        this.m_children.add(child);
        child.setParent(this);
        this.childNodeChanged(this);
    }

    public void dispose() {
        this.dispose(this.getChildren());
    }

    public ITreeDataNode findChild(Object data) {
        for (ITreeDataNode node : this.m_children) {
            if (!node.getData().equals(data)) continue;
            return node;
        }
        return null;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public ITreeDataNode[] getChildren() {
        return this.m_children.toArray(new ITreeDataNode[this.m_children.size()]);
    }

    public boolean hasChildren() {
        return this.m_children.size() > 0;
    }

    public void onOpen() {
    }

    public void removeAllChildren() {
        for (ITreeDataNode child : this.m_children) {
            child.setParent(null);
        }
        this.m_children.clear();
        this.childNodeChanged(this);
    }

    public void removeChild(ITreeDataNode child) {
        this.m_children.remove(child);
        child.setParent(null);
        this.childNodeChanged(this);
    }

    public void replaceChild(ITreeDataNode child, ITreeDataNode newChild) {
        int idx = this.m_children.indexOf(child);
        this.m_children.set(idx, newChild);
        child.setParent(null);
        newChild.setParent(this);
        this.childNodeChanged(this);
    }

    public void replaceChild(ITreeDataNode child, ITreeDataNode[] newChildren) {
        int idx = this.m_children.indexOf(child);
        this.m_children.remove(idx);
        child.setParent(null);
        int i = 0;
        while (i < newChildren.length) {
            this.m_children.add(idx + i, newChildren[i]);
            newChildren[i].setParent(this);
            ++i;
        }
        this.childNodeChanged(this);
    }

    private void dispose(ITreeDataNode[] children) {
        if (children == null || children.length < 1) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }
}

