/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;

public class Install
extends AbstractCommand {
    private URI m_site;
    private Version m_version;
    private String m_feature;

    static ProvisioningContext createContext(URI site) {
        URI[] repoLocations = new URI[]{site};
        ProvisioningContext context = new ProvisioningContext(repoLocations);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    static IInstallableUnit[] getRootIUs(URI site, IProfile profile, String iuName, Version version, IProgressMonitor monitor) throws SimpleErrorExitException {
        InstallableUnitQuery query;
        Collector roots;
        if (!iuName.endsWith(".feature.group")) {
            iuName = String.valueOf(iuName) + ".feature.group";
        }
        if ((roots = ProvisioningHelper.getInstallableUnits((URI)site, (Query)new CompositeQuery(new Query[]{query = new InstallableUnitQuery(iuName, version == null ? VersionRange.emptyRange : new VersionRange(version, true, version, true)), new LatestIUVersionQuery()}), (Collector)new Collector(), (IProgressMonitor)monitor)).size() <= 0) {
            roots = profile.query((Query)query, roots, (IProgressMonitor)new NullProgressMonitor());
        }
        if (roots.size() <= 0) {
            throw new SimpleErrorExitException(NLS.bind((String)Messages.no_suitable_feature_version_found_matching_0, (Object)iuName));
        }
        return (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
    }

    static URI normalizeToURI(String surl) {
        URL url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            try {
                url = new File(surl).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.URL_0_malformed, (Object)surl));
            }
        }
        return URI.create(url.toString());
    }

    static int planAndExecute(IProfile profile, ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) throws CoreException {
        ProvisioningPlan plan;
        Buckminster bucky = Buckminster.getDefault();
        IPlanner planner = (IPlanner)bucky.getService(IPlanner.class);
        try {
            plan = planner.getProvisioningPlan(request, context, monitor);
            IStatus status = plan.getStatus();
            if (status.getSeverity() == 8) {
                return 2;
            }
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
        }
        finally {
            bucky.ungetService((Object)planner);
        }
        IEngine engine = (IEngine)bucky.getService(IEngine.class);
        try {
            IStatus status = engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), context, monitor);
            if (status.getSeverity() == 8) {
                return 2;
            }
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
        }
        finally {
            bucky.ungetService((Object)engine);
        }
        return 0;
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 3) {
            throw new UsageException(Messages.too_many_arguments);
        }
        if (len > 0) {
            String p2Repos = unparsed[0];
            if (p2Repos.endsWith("/headless-site.xml")) {
                p2Repos = p2Repos.substring(0, p2Repos.length() - 18);
            } else if (p2Repos.endsWith("/site.xml")) {
                p2Repos = p2Repos.substring(0, p2Repos.length() - 9);
            }
            this.m_site = Install.normalizeToURI(p2Repos);
        }
        if (len > 1) {
            this.m_feature = unparsed[1];
        }
        if (len > 2) {
            this.m_version = Version.parseVersion((String)unparsed[2]);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.m_site == null) {
            throw new UsageException(Messages.no_site_provided);
        }
        if (this.m_feature == null) {
            throw new UsageException(Messages.no_feature_id_provided);
        }
        Buckminster bucky = Buckminster.getDefault();
        String profileId = bucky.getBundle().getBundleContext().getProperty("eclipse.p2.profile");
        if (profileId == null) {
            profileId = "Buckminster";
            System.setProperty("eclipse.p2.profile", profileId);
        }
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)bucky.getService(IProfileRegistry.class);
        try {
            IProfile profile = profileRegistry.getProfile(profileId);
            IInstallableUnit[] rootArr = Install.getRootIUs(this.m_site, profile, this.m_feature, this.m_version, monitor);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            IInstallableUnit[] iInstallableUnitArray = rootArr;
            int n = rootArr.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit rootIU = iInstallableUnitArray[n2];
                request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
                ++n2;
            }
            request.addInstallableUnits(rootArr);
            int n3 = Install.planAndExecute(profile, request, Install.createContext(this.m_site), monitor);
            return n3;
        }
        finally {
            bucky.ungetService((Object)profileRegistry);
        }
    }
}

