/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.Install;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class Uninstall
extends AbstractCommand {
    private Version m_version;
    private String m_feature;

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 2) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len > 0) {
            this.m_feature = unparsed[0];
        }
        if (len > 1) {
            try {
                this.m_version = Version.parseVersion((String)unparsed[1]);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleErrorExitException(NLS.bind((String)"Unable to parse version: {0}", (Object)unparsed[1], (Object)e.getMessage()));
            }
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.m_feature == null) {
            throw new SimpleErrorExitException(Messages.no_feature_id_provided);
        }
        monitor.beginTask(null, -1);
        IProfile profile = ProvisioningHelper.getProfile((String)"_SELF_");
        IInstallableUnit[] rootArr = Install.getRootIUs(null, profile, this.m_feature, this.m_version, monitor);
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] iInstallableUnitArray = rootArr;
        int n = rootArr.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit rootIU = iInstallableUnitArray[n2];
            request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
            ++n2;
        }
        request.removeInstallableUnits(rootArr);
        return Install.planAndExecute(profile, request, null, monitor);
    }
}

